/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionArgument;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.impl.FunctionProvider;
import org.eclipse.birt.report.data.adapter.api.LinkedDataSetUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.data.ui.aggregation.AggregationUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.IIndexInfo;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.InheritedComputedColumnHandle;
import org.eclipse.birt.report.designer.ui.dialogs.Operator;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.expressions.IExpressionFilterSupport;
import org.eclipse.birt.report.designer.ui.expressions.ISortableExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.ILocalizableInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;

public class ExpressionProvider
implements ISortableExpressionProvider,
IExpressionFilterSupport {
    protected static final Operator[] OPERATORS_ASSIGNMENT = new Operator[]{new Operator("=", Messages.getString((String)"ExpressionProvider.Operator.Assign")), new Operator("+=", Messages.getString((String)"ExpressionProvider.Operator.AddTo")), new Operator("-=", Messages.getString((String)"ExpressionProvider.Operator.SubFrom")), new Operator("*=", Messages.getString((String)"ExpressionProvider.Operator.MultTo")), new Operator("/=", Messages.getString((String)"ExpressionProvider.Operator.DividingFrom"))};
    protected static Operator[] OPERATORS_COMPARISON = new Operator[]{new Operator("==", Messages.getString((String)"ExpressionProvider.Operator.Equals")), new Operator("<", Messages.getString((String)"ExpressionProvider.Operator.Less")), new Operator("<=", Messages.getString((String)"ExpressionProvider.Operator.LessEqual")), new Operator("!=", Messages.getString((String)"ExpressionProvider.Operator.NotEqual")), new Operator(">", Messages.getString((String)"ExpressionProvider.Operator.Greater")), new Operator(">=", Messages.getString((String)"ExpressionProvider.Operator.GreaterEquals"))};
    protected static final Operator[] OPERATORS_COMPUTATIONAL = new Operator[]{new Operator("+", Messages.getString((String)"ExpressionProvider.Operator.Add")), new Operator("-", Messages.getString((String)"ExpressionProvider.Operator.Sub")), new Operator("*", Messages.getString((String)"ExpressionProvider.Operator.Mult")), new Operator("/", Messages.getString((String)"ExpressionProvider.Operator.Divides")), new Operator("++ ", Messages.getString((String)"ExpressionProvider.Operator.Inc")), new Operator("-- ", Messages.getString((String)"ExpressionProvider.Operator.Dec"))};
    protected static final Operator[] OPERATORS_LOGICAL = new Operator[]{new Operator("&&", Messages.getString((String)"ExpressionProvider.Operator.And")), new Operator("||", Messages.getString((String)"ExpressionProvider.Operator.Or"))};
    protected static final Operator[] OPERATORS_ON_BAR = new Operator[]{OPERATORS_COMPUTATIONAL[0], OPERATORS_COMPUTATIONAL[1], OPERATORS_COMPUTATIONAL[2], OPERATORS_COMPUTATIONAL[3], OPERATOR_SEPARATOR, new Operator("!", Messages.getString((String)"ExpressionProvider.Operator.Not")), new Operator("=", Messages.getString((String)"ExpressionProvider.Operator.Equals")), OPERATORS_COMPARISON[1], OPERATORS_COMPARISON[4], OPERATOR_SEPARATOR, new Operator("&", Messages.getString((String)"ExpressionProvider.Operator.BitAnd")), new Operator("|", Messages.getString((String)"ExpressionProvider.Operator.BitOr")), new Operator("(", Messages.getString((String)"ExpressionProvider.Operator.LeftBracket")), new Operator(")", Messages.getString((String)"ExpressionProvider.Operator.RightBracket"))};
    protected static final String DISPLAY_TEXT_ASSIGNMENT = Messages.getString((String)"ExpressionProvider.Operators.Assignment");
    protected static final String DISPLAY_TEXT_COMPARISON = Messages.getString((String)"ExpressionProvider.Operators.Comparison");
    protected static final String DISPLAY_TEXT_COMPUTATIONAL = Messages.getString((String)"ExpressionProvider.Operators.Computational");
    protected static final String DISPLAY_TEXT_LOGICAL = Messages.getString((String)"ExpressionProvider.Operators.Logical");
    protected static final Image IMAGE_OPERATOR = ExpressionProvider.getIconImage("Operator");
    protected static final Image IMAGE_COLUMN = ExpressionProvider.getIconImage("DataColumn");
    protected static final Image IMAGE_CONSTRUCTOR = ExpressionProvider.getIconImage("Constructor");
    protected static final Image IMAGE_METHOD = ExpressionProvider.getIconImage("Method");
    protected static final Image IMAGE_STATIC_METHOD = ExpressionProvider.getIconImage("Static Method");
    protected static final Image IMAGE_MEMBER = ExpressionProvider.getIconImage("Member");
    protected static final Image IMAGE_STATIC_MEMBER = ExpressionProvider.getIconImage("Static Member");
    protected static final Image IMAGE_LEVEL_ATTRI = ExpressionProvider.getIconImage("levelAttribute");
    public static final String DATASETS = Messages.getString((String)"ExpressionProvider.Category.DataSets");
    public static final String OPERATORS = Messages.getString((String)"ExpressionProvider.Category.Operators");
    public static final String COLUMN_BINDINGS = Messages.getString((String)"ExpressionProvider.Category.ColumnBinding");
    public static final String CURRENT_CUBE = Messages.getString((String)"ExpressionProvider.Category.DataCubes");
    public static final String AVAILABLE_MEASURES = Messages.getString((String)"ExpressionProvider.Category.AvailableMeasures");
    public static final String MEASURE = "Measure";
    public static final String PARAMETERS = Messages.getString((String)"ExpressionProvider.Category.Parameters");
    public static final String VARIABLES = Messages.getString((String)"ExpressionProvider.Variables");
    public static final String VARIABLES_REPORT = Messages.getString((String)"ExpressionProvider.Variables.Report");
    public static final String VARIABLES_PAGE = Messages.getString((String)"ExpressionProvider.Variables.Page");
    public static final String NATIVE_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.NativeObjects");
    public static final String BIRT_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.BirtObjects");
    protected static final String ALL = Messages.getString((String)"ExpressionProvider.Label.All");
    private static final String TOOLTIP_BINDING_PREFIX = Messages.getString((String)"ExpressionProvider.Tooltip.ColumnBinding");
    protected DesignElementHandle elementHandle;
    protected IExpressionProvider adapterProvider;
    protected AlphabeticallyComparator innerComparator = new AlphabeticallyComparator();
    protected List<ExpressionFilter> filterList;
    private boolean includeSelf;

    public ExpressionProvider() {
        this(null);
    }

    public ExpressionProvider(DesignElementHandle handle) {
        this(handle, true);
    }

    public ExpressionProvider(DesignElementHandle handle, boolean includeSelf) {
        this.elementHandle = handle == null ? SessionHandleAdapter.getInstance().getReportDesignHandle() : handle;
        this.includeSelf = includeSelf;
        this.initAdapterProvider();
    }

    @Override
    public Operator[] getOperators() {
        Operator[] cats;
        if (this.adapterProvider != null && (cats = this.adapterProvider.getOperators()) != null) {
            Operator[] rt = new Operator[OPERATORS_ON_BAR.length + cats.length];
            System.arraycopy(OPERATORS_ON_BAR, 0, rt, 0, OPERATORS_ON_BAR.length);
            System.arraycopy(cats, 0, rt, OPERATORS_ON_BAR.length, cats.length);
            return rt;
        }
        return OPERATORS_ON_BAR;
    }

    @Override
    public Object[] getCategory() {
        Object[] category = this.getCategoryList().toArray();
        if (this.filterList != null && !this.filterList.isEmpty()) {
            for (ExpressionFilter ft : this.filterList) {
                category = ft.filter("Category", category);
            }
        }
        return category;
    }

    protected List<Object> getCategoryList() {
        Object[] cats;
        ArrayList<Object> categoryList = new ArrayList<Object>(5);
        if (this.getChildren(COLUMN_BINDINGS).length > 0) {
            categoryList.add(COLUMN_BINDINGS);
        }
        if (this.elementHandle instanceof ReportItemHandle && ((ReportItemHandle)this.elementHandle).getCube() != null && !LinkedDataSetUtil.bindToLinkedDataSet((ReportItemHandle)((ReportItemHandle)this.elementHandle))) {
            categoryList.add(CURRENT_CUBE);
        }
        if (this.elementHandle.getModuleHandle().getParameters() != null && this.elementHandle.getModuleHandle().getParameters().getCount() != 0) {
            categoryList.add(PARAMETERS);
        }
        categoryList.add(NATIVE_OBJECTS);
        categoryList.add(BIRT_OBJECTS);
        categoryList.add(OPERATORS);
        if (this.elementHandle.getModuleHandle() instanceof ReportDesignHandle && ((ReportDesignHandle)this.elementHandle.getModuleHandle()).getPageVariables().size() > 0) {
            for (VariableElementHandle veh : ((ReportDesignHandle)this.elementHandle.getModuleHandle()).getPageVariables()) {
                if (!"report".equals(veh.getType())) continue;
                categoryList.add(VARIABLES);
                break;
            }
        }
        if (this.adapterProvider != null && (cats = this.adapterProvider.getCategory()) != null) {
            categoryList.addAll(Arrays.asList(cats));
        }
        return categoryList;
    }

    @Override
    public Object[] getSortedChildren(Object parentElement) {
        return this.sortChildren(parentElement, this.getChildren(parentElement));
    }

    protected Object[] sortElements(Object[] children) {
        TreeMap<String, Object> map = new TreeMap<String, Object>((Comparator<String>)this.innerComparator);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            map.put(this.getDisplayText(obj), obj);
            ++n2;
        }
        return map.values().toArray(new Object[map.size()]);
    }

    protected int innerCompare(Object o1, Object o2) {
        return this.innerComparator.compare((Object)this.getDisplayText(o1), (Object)this.getDisplayText(o2));
    }

    protected Object[] sortChildren(Object parent, Object[] children) {
        if (children == null) {
            return null;
        }
        if (parent instanceof String) {
            if (ALL.equals(parent)) {
                return this.sortElements(children);
            }
            return children;
        }
        if (parent instanceof IClassInfo) {
            Object[] result = new Object[children.length];
            System.arraycopy(children, 0, result, 0, children.length);
            Arrays.sort(result, new Comparator<Object>(){

                private int computeWeight(Object obj) {
                    if (obj instanceof IMemberInfo) {
                        return ((IMemberInfo)obj).isStatic() ? 0 : 2;
                    }
                    if (obj instanceof IMethodInfo) {
                        if (((IMethodInfo)obj).isConstructor()) {
                            return 3;
                        }
                        return ((IMethodInfo)obj).isStatic() ? 1 : 4;
                    }
                    return 4;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof ILocalizableInfo[] && o2 instanceof ILocalizableInfo[]) {
                        int w2;
                        ILocalizableInfo info1 = ((ILocalizableInfo[])o1)[1];
                        ILocalizableInfo info2 = ((ILocalizableInfo[])o2)[1];
                        int w1 = this.computeWeight(info1);
                        if (w1 != (w2 = this.computeWeight(info2))) {
                            return w1 < w2 ? -1 : 1;
                        }
                    }
                    return ExpressionProvider.this.innerCompare(o1, o2);
                }
            });
            return result;
        }
        if (parent instanceof ReportItemHandle || parent instanceof GroupHandle) {
            Object[] result = new Object[children.length];
            System.arraycopy(children, 0, result, 0, children.length);
            Arrays.sort(result, new Comparator<Object>(){

                private int computeWeight(Object obj) {
                    if (obj instanceof ComputedColumnHandle) {
                        return 0;
                    }
                    if (obj instanceof InheritedComputedColumnHandle) {
                        return 1;
                    }
                    if (obj instanceof Expression) {
                        return 2;
                    }
                    return 3;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    int w2;
                    int w1 = this.computeWeight(o1);
                    if (w1 == (w2 = this.computeWeight(o2))) {
                        return ExpressionProvider.this.innerCompare(o1, o2);
                    }
                    return w1 < w2 ? -1 : 1;
                }
            });
            return result;
        }
        return this.sortElements(children);
    }

    @Override
    public Object[] getChildren(Object parent) {
        Object[] children = this.getChildrenList(parent).toArray();
        if (this.filterList != null && !this.filterList.isEmpty()) {
            for (ExpressionFilter ft : this.filterList) {
                children = ft.filter(parent, children);
            }
        }
        return children;
    }

    protected List<Object> getChildrenList(Object parent) {
        Object[] cats;
        ArrayList<Object> childrenList = new ArrayList<Object>();
        if (parent instanceof IAdaptable) {
            parent = DNDUtil.unwrapToModel((Object)parent);
        }
        if (parent instanceof Object[]) {
            Object[] array = (Object[])parent;
            if (array instanceof Operator[]) {
                return Arrays.asList(array);
            }
            int i = 0;
            while (i < array.length) {
                Object[] children = this.getChildren(array[i]);
                childrenList.addAll(Arrays.asList(children));
                ++i;
            }
        } else if (parent instanceof String) {
            if (PARAMETERS.equals(parent)) {
                childrenList.add(ALL);
                for (Object obj : this.elementHandle.getModuleHandle().getParameters()) {
                    if (!(obj instanceof ParameterGroupHandle)) continue;
                    childrenList.add(obj);
                }
            } else if (ALL.equals(parent)) {
                for (Object obj : this.elementHandle.getModuleHandle().getParameters()) {
                    if (!(obj instanceof ParameterHandle)) continue;
                    childrenList.add(obj);
                }
            }
            if (VARIABLES.equals(parent)) {
                childrenList.add(VARIABLES_REPORT);
            }
            if (VARIABLES_REPORT.equals(parent)) {
                for (VariableElementHandle variable : ((ReportDesignHandle)this.elementHandle.getModuleHandle()).getPageVariables()) {
                    if (!"report".equals(variable.getType())) continue;
                    childrenList.add(variable);
                }
            } else if (COLUMN_BINDINGS.equals(parent)) {
                childrenList.addAll(this.getAllBindingElementHandles());
            } else if (CURRENT_CUBE.equals(parent)) {
                Object nodeProviderAdapter;
                CubeHandle cube = this.getCube(this.elementHandle);
                if (cube != null && (nodeProviderAdapter = ElementAdapterManager.getAdapter(cube, INodeProvider.class)) != null) {
                    return Arrays.asList(((INodeProvider)nodeProviderAdapter).getChildren(cube));
                }
            } else if (BIRT_OBJECTS.equals(parent)) {
                childrenList.addAll(this.getClassList(false));
                try {
                    IScriptFunctionCategory[] categorys = FunctionProvider.getCategories();
                    int i = 0;
                    while (i < categorys.length) {
                        if (categorys[i].isVisible()) {
                            childrenList.add(categorys[i]);
                        }
                        ++i;
                    }
                }
                catch (BirtException e) {
                    ExceptionHandler.handle(e);
                }
            } else if (NATIVE_OBJECTS.equals(parent)) {
                childrenList.addAll(this.getClassList(true));
            } else if (OPERATORS.equals(parent)) {
                childrenList.add(OPERATORS_ASSIGNMENT);
                childrenList.add(OPERATORS_COMPARISON);
                childrenList.add(OPERATORS_COMPUTATIONAL);
                childrenList.add(OPERATORS_LOGICAL);
                childrenList.add(0, childrenList.toArray());
            }
        } else if (parent instanceof IClassInfo) {
            IClassInfo classInfo = (IClassInfo)parent;
            Iterator iter = DEUtil.getMembers((IClassInfo)classInfo).iterator();
            while (iter.hasNext()) {
                childrenList.add(new ILocalizableInfo[]{classInfo, (IMemberInfo)iter.next()});
            }
            for (IMethodInfo mi : DEUtil.getMethods((IClassInfo)classInfo, (boolean)true)) {
                this.processMethods(classInfo, mi, childrenList);
            }
            for (IMethodInfo mi : AggregationUtil.getMethods(classInfo)) {
                this.processMethods(classInfo, mi, childrenList);
            }
        } else if (parent instanceof IScriptFunctionCategory) {
            try {
                IScriptFunction[] functions = ((IScriptFunctionCategory)parent).getFunctions();
                int i = 0;
                while (i < functions.length) {
                    if (functions[i].isVisible()) {
                        childrenList.add(functions[i]);
                    }
                    ++i;
                }
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
            }
        } else if (parent instanceof ParameterGroupHandle) {
            childrenList.addAll(((ParameterGroupHandle)parent).getParameters().getContents());
        } else if (parent instanceof ReportItemHandle || parent instanceof GroupHandle) {
            if (parent instanceof ReportItemHandle) {
                ArrayList<String> nameList = new ArrayList<String>();
                Iterator<ComputedColumnHandle> iter = this.getColumnBindings((ReportItemHandle)parent);
                while (iter.hasNext()) {
                    ComputedColumnHandle column = iter.next();
                    childrenList.add(column);
                    nameList.add(column.getName());
                }
                if (parent == this.elementHandle) {
                    ReportItemHandle root = DEUtil.getBindingRoot((DesignElementHandle)this.elementHandle);
                    DesignElementHandle container = this.elementHandle;
                    while (root != null && container != null && container != root) {
                        if (!((container = container.getContainer()) instanceof ReportItemHandle)) continue;
                        Iterator<ComputedColumnHandle> iter1 = this.getColumnBindings((ReportItemHandle)container);
                        while (iter1.hasNext()) {
                            ComputedColumnHandle column = iter1.next();
                            if (nameList.contains(column.getName())) continue;
                            childrenList.add(new InheritedComputedColumnHandle(column));
                            nameList.add(column.getName());
                        }
                    }
                }
            }
            if (DEUtil.enableRowNum((Object)parent)) {
                Expression rowNum = new Expression(Messages.getString((String)"ExpressionProvider.Expression.RowNumName"), DEUtil.getRowNumExpression((DesignElementHandle)this.elementHandle, (DesignElementHandle)((ReportItemHandle)parent)), Messages.getString((String)"ExpressionProvider.Expression.RowNumTooltip"));
                childrenList.add(rowNum);
            }
            this.addEditBindingsItem(childrenList, Messages.getString((String)"ExpressionProvider.EditBindings"), parent);
        } else {
            Object nodeProviderAdapter = ElementAdapterManager.getAdapter(parent, INodeProvider.class);
            if (nodeProviderAdapter != null) {
                ArrayList<Object> children = new ArrayList<Object>();
                children.addAll(Arrays.asList(((INodeProvider)nodeProviderAdapter).getChildren(parent)));
                return children;
            }
        }
        if (this.adapterProvider != null && (cats = this.adapterProvider.getChildren(parent)) != null) {
            childrenList.addAll(Arrays.asList(cats));
        }
        return childrenList;
    }

    private CubeHandle getCube(Object input) {
        if (input instanceof CubeHandle) {
            return (CubeHandle)input;
        }
        if (input instanceof ReportItemHandle && ((ReportItemHandle)input).getCube() != null) {
            return ((ReportItemHandle)input).getCube();
        }
        return this.getCubeHandle(input);
    }

    private CubeHandle getCubeHandle(Object input) {
        DesignElementHandle parent = null;
        if (input instanceof LevelHandle) {
            parent = ((LevelHandle)input).getContainer().getContainer().getContainer();
        } else if (input instanceof HierarchyHandle) {
            parent = ((HierarchyHandle)input).getContainer().getContainer();
        } else if (input instanceof DimensionHandle) {
            parent = ((DimensionHandle)input).getContainer();
        } else if (input instanceof MeasureHandle) {
            parent = ((MeasureHandle)input).getContainer().getContainer();
        } else if (input instanceof MeasureGroupHandle) {
            parent = ((MeasureGroupHandle)input).getContainer();
        }
        if (parent instanceof CubeHandle) {
            return (CubeHandle)parent;
        }
        return null;
    }

    protected void addEditBindingsItem(ArrayList<Object> childrenList, String itemText, Object parent) {
        childrenList.add(new Object[]{itemText, parent});
    }

    /*
     * Unable to fully structure code
     */
    private void processMethods(IClassInfo classInfo, IMethodInfo mi, List childrenList) {
        block1: {
            alitr = mi.argumentListIterator();
            idx = 0;
            if (alitr != null) ** GOTO lbl11
            childrenList.add(new ILocalizableInfo[]{classInfo, mi});
            break block1;
lbl-1000:
            // 1 sources

            {
                alitr.next();
                childrenList.add(new ILocalizableInfo[]{classInfo, mi, new IIndexInfo(idx++)});
lbl11:
                // 2 sources

                ** while (alitr.hasNext())
            }
        }
    }

    protected List<DesignElementHandle> getAllBindingElementHandles() {
        ArrayList<DesignElementHandle> childrenList = new ArrayList<DesignElementHandle>();
        List bindingList = this.getAllColumnBindingList();
        Collections.reverse(bindingList);
        for (ComputedColumnHandle handle : bindingList) {
            if (childrenList.contains(handle.getElementHandle())) continue;
            childrenList.add(handle.getElementHandle());
        }
        return childrenList;
    }

    protected List getAllColumnBindingList() {
        List bindingList = DEUtil.getAllColumnBindingList((DesignElementHandle)this.elementHandle, (boolean)this.includeSelf);
        return bindingList;
    }

    @Override
    public String getDisplayText(Object element) {
        String txt;
        Object nodeProviderAdapter = ElementAdapterManager.getAdapter(element, INodeProvider.class);
        if (nodeProviderAdapter != null) {
            return ((INodeProvider)nodeProviderAdapter).getNodeDisplayName(element);
        }
        if (element instanceof Object[]) {
            Object[] inputArray;
            if (element instanceof Operator[]) {
                if (element == OPERATORS_ASSIGNMENT) {
                    return DISPLAY_TEXT_ASSIGNMENT;
                }
                if (element == OPERATORS_COMPARISON) {
                    return DISPLAY_TEXT_COMPARISON;
                }
                if (element == OPERATORS_COMPUTATIONAL) {
                    return DISPLAY_TEXT_COMPUTATIONAL;
                }
                if (element == OPERATORS_LOGICAL) {
                    return DISPLAY_TEXT_LOGICAL;
                }
            } else if (element instanceof ILocalizableInfo[]) {
                ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
                StringBuffer displayText = new StringBuffer(info.getName());
                if (info instanceof IMethodInfo) {
                    IMethodInfo method = (IMethodInfo)info;
                    displayText.append("(");
                    int argIndex = ((ILocalizableInfo[])element).length > 2 ? ((IIndexInfo)((ILocalizableInfo[])element)[2]).getIndex() : 0;
                    int idx = -1;
                    Iterator argumentListIter = method.argumentListIterator();
                    while (argumentListIter.hasNext()) {
                        IArgumentInfoList arguments = (IArgumentInfoList)argumentListIter.next();
                        if (++idx < argIndex) continue;
                        boolean isFirst = true;
                        Iterator iter = arguments.argumentsIterator();
                        while (iter.hasNext()) {
                            IArgumentInfo argInfo = (IArgumentInfo)iter.next();
                            if (!isFirst) {
                                displayText.append(", ");
                            }
                            isFirst = false;
                            displayText.append(argInfo.getDisplayName());
                            if (argInfo.getType() == null) continue;
                            displayText.append(":" + argInfo.getType());
                        }
                        break block0;
                    }
                    displayText.append(")");
                    if (!method.isConstructor()) {
                        displayText.append(" : ");
                        String returnType = method.getReturnType();
                        if (returnType == null) {
                            returnType = "void";
                        }
                        displayText.append(returnType);
                    }
                } else if (info instanceof IMemberInfo) {
                    displayText.append(" : ");
                    displayText.append(((IMemberInfo)info).getDataType());
                }
                return displayText.toString();
            }
            if ((inputArray = (Object[])element).length == 2 && inputArray[1] instanceof ReportItemHandle) {
                return inputArray[0].toString();
            }
            return ALL;
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof Operator) {
            return ((Operator)element).symbol;
        }
        if (element instanceof DesignElementHandle) {
            return DEUtil.getDisplayLabel((Object)element, (boolean)false);
        }
        if (element instanceof ComputedColumnHandle) {
            return ((ComputedColumnHandle)element).getName();
        }
        if (element instanceof InheritedComputedColumnHandle) {
            return ((InheritedComputedColumnHandle)element).getName();
        }
        if (element instanceof Expression) {
            return ((Expression)element).symbol;
        }
        if (element instanceof LevelAttributeHandle) {
            return ((LevelAttributeHandle)element).getName();
        }
        if (element instanceof IScriptFunctionCategory) {
            String categoreName = ((IScriptFunctionCategory)element).getName() == null ? Messages.getString((String)"ExpressionTreeSupport.Category.Global") : ((IScriptFunctionCategory)element).getName();
            return categoreName;
        }
        if (element instanceof IScriptFunction) {
            IScriptFunction function = (IScriptFunction)element;
            StringBuffer displayText = new StringBuffer(function.getName());
            IScriptFunctionArgument[] arguments = function.getArguments();
            displayText.append("(");
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    displayText.append(arguments[i].getName());
                    if (arguments[i].getDataTypeName() != null) {
                        displayText.append(":" + arguments[i].getDataTypeName().trim());
                    }
                    if (i < arguments.length - 1) {
                        displayText.append(", ");
                    }
                    ++i;
                }
            }
            displayText.append(")");
            if (!function.isConstructor()) {
                displayText.append(" : ");
                String returnType = function.getDataTypeName();
                if (returnType == null) {
                    returnType = "void";
                }
                displayText.append(returnType);
            }
            return displayText.toString();
        }
        if (this.adapterProvider != null && (txt = this.adapterProvider.getDisplayText(element)) != null) {
            return txt;
        }
        return element.toString();
    }

    @Override
    public String getTooltipText(Object element) {
        String txt;
        if (element instanceof Operator) {
            return ((Operator)element).tooltip;
        }
        if (element instanceof Expression) {
            return ((Expression)element).tooltip;
        }
        if (element instanceof ILocalizableInfo[]) {
            return ((ILocalizableInfo[])element)[1].getToolTip();
        }
        if (element instanceof IScriptFunction) {
            return ((IScriptFunction)element).getDescription();
        }
        if (element instanceof IScriptFunctionCategory) {
            return ((IScriptFunctionCategory)element).getDescription();
        }
        if (element instanceof ComputedColumnHandle) {
            return String.valueOf(TOOLTIP_BINDING_PREFIX) + DataUtil.getAggregationExpression((ComputedColumnHandle)element);
        }
        if (element instanceof InheritedComputedColumnHandle) {
            return String.valueOf(TOOLTIP_BINDING_PREFIX) + ((InheritedComputedColumnHandle)element).getHandle().getExpression();
        }
        if (this.adapterProvider != null && (txt = this.adapterProvider.getTooltipText(element)) != null) {
            return txt;
        }
        return this.getDisplayText(element);
    }

    @Override
    public Image getImage(Object element) {
        Object nodeProviderAdapter = ElementAdapterManager.getAdapter(element, INodeProvider.class);
        if (nodeProviderAdapter != null) {
            return ((INodeProvider)nodeProviderAdapter).getNodeIcon(element);
        }
        if (element instanceof Operator) {
            return IMAGE_OPERATOR;
        }
        if (element instanceof ILocalizableInfo[]) {
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            if (info instanceof IMethodInfo) {
                if (((IMethodInfo)info).isStatic()) {
                    return IMAGE_STATIC_METHOD;
                }
                if (((IMethodInfo)info).isConstructor()) {
                    return IMAGE_CONSTRUCTOR;
                }
                return IMAGE_METHOD;
            }
            if (info instanceof IMemberInfo) {
                if (((IMemberInfo)info).isStatic()) {
                    return IMAGE_STATIC_MEMBER;
                }
                return IMAGE_MEMBER;
            }
        } else {
            if (element instanceof IScriptFunction) {
                if (((IScriptFunction)element).isStatic()) {
                    return IMAGE_STATIC_METHOD;
                }
                if (((IScriptFunction)element).isConstructor()) {
                    return IMAGE_CONSTRUCTOR;
                }
                return IMAGE_METHOD;
            }
            if (element instanceof ComputedColumnHandle || element instanceof ResultSetColumnHandle || element instanceof DataSetItemModel || element instanceof Expression) {
                return IMAGE_COLUMN;
            }
            if (element instanceof InheritedComputedColumnHandle) {
                return ReportPlatformUIImages.getImage("InheritColumn");
            }
            if (element instanceof DesignElementHandle) {
                return ReportPlatformUIImages.getImage(element);
            }
            if (element instanceof LevelAttributeHandle) {
                return IMAGE_LEVEL_ATTRI;
            }
        }
        if (this.adapterProvider != null) {
            return this.adapterProvider.getImage(element);
        }
        return null;
    }

    @Override
    public String getInsertText(Object element) {
        if (element instanceof Operator) {
            return ((Operator)element).insertString;
        }
        if (element instanceof Expression) {
            return ((Expression)element).insertString;
        }
        if (element instanceof ILocalizableInfo[]) {
            IClassInfo classInfo = (IClassInfo)((ILocalizableInfo[])element)[0];
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            StringBuffer insertText = new StringBuffer();
            if (info instanceof IMemberInfo) {
                IMemberInfo memberInfo = (IMemberInfo)info;
                if (memberInfo.isStatic()) {
                    insertText.append(String.valueOf(classInfo.getName()) + ".");
                }
                insertText.append(memberInfo.getName());
            } else if (info instanceof IMethodInfo) {
                IMethodInfo methodInfo = (IMethodInfo)info;
                if (methodInfo.isStatic()) {
                    insertText.append(String.valueOf(classInfo.getName()) + ".");
                } else if (methodInfo.isConstructor()) {
                    insertText.append("new ");
                }
                insertText.append(methodInfo.getName());
                insertText.append("()");
            }
            return insertText.toString();
        }
        if (element instanceof IScriptFunction) {
            IScriptFunction function = (IScriptFunction)element;
            StringBuffer insertText = new StringBuffer();
            if (function.isStatic()) {
                if (function.getCategory().getName() != null) {
                    insertText.append(String.valueOf(function.getCategory().getName()) + ".");
                }
            } else if (function.isConstructor()) {
                insertText.append("new ");
            }
            insertText.append(function.getName());
            insertText.append("()");
            return insertText.toString();
        }
        if (element instanceof ParameterHandle) {
            return DEUtil.getExpression((Object)element);
        }
        if (element instanceof VariableElementHandle) {
            return DEUtil.getExpression((Object)element);
        }
        if (element instanceof ComputedColumnHandle) {
            return DEUtil.getBindingexpression((DesignElementHandle)this.elementHandle, (ComputedColumnHandle)((ComputedColumnHandle)element));
        }
        if (element instanceof InheritedComputedColumnHandle) {
            return DEUtil.getBindingexpression((DesignElementHandle)this.elementHandle, (ComputedColumnHandle)((InheritedComputedColumnHandle)element).getHandle(), (boolean)false);
        }
        if (element instanceof LevelHandle || element instanceof MeasureHandle || element instanceof LevelAttributeHandle) {
            return DEUtil.getExpression((Object)element);
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (this.adapterProvider != null) {
            return this.adapterProvider.getInsertText(element);
        }
        return null;
    }

    private static Image getIconImage(String id) {
        return ReportPlatformUIImages.getImage(id);
    }

    protected List getClassList(boolean isNative) {
        List list = DEUtil.getClasses();
        ArrayList<IClassInfo> resultList = new ArrayList<IClassInfo>();
        for (IClassInfo classInfo : list) {
            if (classInfo.isNative() != isNative || classInfo.getName().equals("Total")) continue;
            resultList.add(classInfo);
        }
        return resultList;
    }

    public void addFilter(ExpressionFilter filter) {
        if (filter == null) {
            return;
        }
        if (this.filterList == null) {
            this.filterList = new ArrayList<ExpressionFilter>();
        }
        if (!this.filterList.contains(filter)) {
            this.filterList.add(filter);
        }
    }

    public void addFilterList(List<ExpressionFilter> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ExpressionFilter ft : list) {
            this.addFilter(ft);
        }
    }

    public void removeFilter(ExpressionFilter filter) {
        if (this.filterList == null) {
            return;
        }
        this.filterList.remove(filter);
    }

    public void clearFilters() {
        if (this.filterList == null) {
            return;
        }
        this.filterList.clear();
    }

    @Override
    public void setFilters(List<ExpressionFilter> filters) {
        this.filterList = filters;
    }

    @Override
    public List<ExpressionFilter> getFilters() {
        return this.filterList;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IAdaptable) {
            element = DNDUtil.unwrapToModel((Object)element);
        }
        if (element instanceof PropertyHandle || element instanceof TabularMeasureGroupHandle || element instanceof DimensionHandle || element instanceof LevelHandle) {
            return this.getChildrenList(element).size() > 0;
        }
        if (this.adapterProvider != null) {
            return this.adapterProvider.hasChildren(element);
        }
        return false;
    }

    protected void initAdapterProvider() {
        this.adapterProvider = null;
        Object adapter = ElementAdapterManager.getAdapter(this, IExpressionProvider.class);
        if (adapter instanceof IExpressionProvider && adapter != this) {
            this.adapterProvider = (IExpressionProvider)adapter;
        }
    }

    protected Iterator<ComputedColumnHandle> getColumnBindings(ReportItemHandle handle) {
        return handle.columnBindingsIterator();
    }

    private static class Expression {
        public String tooltip;
        public String symbol;
        public String insertString;

        Expression(String symbol, String insertString, String tooltip) {
            assert (symbol != null);
            this.symbol = symbol;
            this.insertString = insertString == null ? symbol : insertString;
            this.tooltip = tooltip;
        }
    }
}

