/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbItem;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.IBreadcrumbLabelProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormColors;

public abstract class BreadcrumbViewer
extends StructuredViewer {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    private final Composite fContainer;
    private final ArrayList fBreadcrumbItems = new ArrayList();
    private final ListenerList fMenuListeners = new ListenerList();
    private Image fGradientBackground;
    private BreadcrumbItem fSelectedItem;
    private BreadcrumbItem rootItem = null;

    public BreadcrumbViewer(Composite parent, int style) {
        this.fContainer = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 128, true, false);
        this.fContainer.setLayoutData((Object)layoutData);
        this.fContainer.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        this.fContainer.setBackgroundMode(1);
        this.fContainer.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int height = ((BreadcrumbViewer)BreadcrumbViewer.this).fContainer.getClientArea().height;
                if (BreadcrumbViewer.this.fGradientBackground == null || ((BreadcrumbViewer)BreadcrumbViewer.this).fGradientBackground.getBounds().height != height) {
                    Image image = BreadcrumbViewer.this.createGradientImage(height, event.display);
                    BreadcrumbViewer.this.fContainer.setBackgroundImage(image);
                    if (BreadcrumbViewer.this.fGradientBackground != null) {
                        BreadcrumbViewer.this.fGradientBackground.dispose();
                    }
                    BreadcrumbViewer.this.fGradientBackground = image;
                }
            }
        });
        this.fContainer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BreadcrumbViewer.this.fGradientBackground != null && !BreadcrumbViewer.this.fGradientBackground.isDisposed()) {
                    BreadcrumbViewer.this.fGradientBackground.dispose();
                }
            }
        });
        this.hookControl((Control)this.fContainer);
        int columns = 1000;
        if ((0x200 & style) != 0) {
            columns = 1;
        }
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.fContainer.setLayout((Layout)gridLayout);
        this.fContainer.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                BreadcrumbViewer.this.refresh();
            }
        });
    }

    protected abstract void configureDropDownViewer(TreeViewer var1, Object var2);

    public Control getControl() {
        return this.fContainer;
    }

    protected Object getRoot() {
        if (this.fBreadcrumbItems.isEmpty()) {
            return null;
        }
        return ((BreadcrumbItem)((Object)this.fBreadcrumbItems.get(0))).getData();
    }

    public void reveal(Object element) {
    }

    public boolean isDropDownOpen() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
            if (item.isMenuShown()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Shell getDropDownShell() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
            if (item.isMenuShown()) {
                return item.getDropDownShell();
            }
            ++i;
        }
        return null;
    }

    public ISelectionProvider getDropDownSelectionProvider() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
            if (item.isMenuShown()) {
                return item.getDropDownSelectionProvider();
            }
            ++i;
        }
        return null;
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.fMenuListeners.add((Object)listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.fMenuListeners.remove((Object)listener);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        super.assertContentProviderType(provider);
        Assert.isTrue((boolean)(provider instanceof ITreeContentProvider));
    }

    protected void inputChanged(Object fInput, Object oldInput) {
        if (this.fContainer.isDisposed()) {
            return;
        }
        this.disableRedraw();
        try {
            int lastIndex;
            if (this.fBreadcrumbItems.size() > 0) {
                BreadcrumbItem last = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(this.fBreadcrumbItems.size() - 1));
                last.setIsLastItem(false);
            }
            if ((lastIndex = this.buildItemChain(fInput)) > 0) {
                BreadcrumbItem last = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(lastIndex - 1));
                last.setIsLastItem(true);
            }
            while (lastIndex < this.fBreadcrumbItems.size()) {
                BreadcrumbItem item = (BreadcrumbItem)((Object)this.fBreadcrumbItems.remove(this.fBreadcrumbItems.size() - 1));
                if (item == this.fSelectedItem) {
                    this.selectItem(null);
                }
                if (item.getData() != null) {
                    this.unmapElement(item.getData());
                }
                item.dispose();
            }
            this.updateSize();
            this.fContainer.layout(true, true);
            if (this.fBreadcrumbItems.size() > 0) {
                ((GridData)this.fContainer.getLayoutData()).heightHint = this.fContainer.computeSize((int)-1, (int)-1).y;
            }
        }
        finally {
            this.enableRedraw();
        }
    }

    protected void dealNonBreadcrumb(boolean nonItems) {
    }

    protected Widget doFindInputItem(Object element) {
        if (element == null) {
            return null;
        }
        if (element == this.getInput() || element.equals(this.getInput())) {
            return this.doFindItem(element);
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element == null) {
            return null;
        }
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
            if (item.getData() == element || element.equals(item.getData())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof BreadcrumbItem) {
            BreadcrumbItem item = (BreadcrumbItem)widget;
            if (fullMap) {
                this.associate(element, item);
            } else {
                Object data = item.getData();
                if (data != null) {
                    this.unmapElement(data, (Widget)item);
                }
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            item.refreshArrow();
        }
    }

    protected List getSelectionFromWidget() {
        if (this.fSelectedItem == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.fSelectedItem.getData() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.fSelectedItem.getData());
        return result;
    }

    protected void internalRefresh(Object element) {
        this.disableRedraw();
        try {
            BreadcrumbItem item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null || this.getRoot().equals(element)) {
                int i = 0;
                int size = this.fBreadcrumbItems.size();
                while (i < size) {
                    BreadcrumbItem item1 = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
                    item1.refresh();
                    ++i;
                }
            } else {
                item.refresh();
            }
            if (this.updateSize()) {
                this.fContainer.layout(true, true);
            }
        }
        finally {
            this.enableRedraw();
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        BreadcrumbItem item;
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            item = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
            item.setSelected(false);
            ++i;
        }
        if (l == null) {
            return;
        }
        for (Object element : l) {
            item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null) continue;
            item.setSelected(true);
            this.fSelectedItem = item;
        }
    }

    void selectItem(BreadcrumbItem item) {
        if (this.fSelectedItem != null) {
            this.fSelectedItem.setSelected(false);
        }
        this.fSelectedItem = item;
        this.setSelectionToWidget(this.getSelection(), false);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    int getItemCount() {
        return this.fBreadcrumbItems.size();
    }

    BreadcrumbItem getItem(int index) {
        return (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(index));
    }

    int getIndexOfItem(BreadcrumbItem item) {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem pItem = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
            if (pItem == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void fireDoubleClick() {
        this.fireDoubleClick(new DoubleClickEvent((Viewer)this, this.getSelection()));
    }

    void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    void fireMenuSelection(Object element) {
        this.fireOpen(new OpenEvent((Viewer)this, (ISelection)new StructuredSelection(element)));
    }

    void fireMenuDetect(MenuDetectEvent event) {
        Object[] listeners = this.fMenuListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((MenuDetectListener)listeners[i]).menuDetected(event);
            ++i;
        }
    }

    void doTraverse(boolean next) {
        if (this.fSelectedItem == null) {
            return;
        }
        int index = this.fBreadcrumbItems.indexOf((Object)this.fSelectedItem);
        if (next) {
            if (index == this.fBreadcrumbItems.size() - 1) {
                BreadcrumbItem current = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(index));
                ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
                if (!contentProvider.hasChildren(current.getData())) {
                    return;
                }
                current.openDropDownMenu();
                current.getDropDownShell().setFocus();
            } else {
                BreadcrumbItem nextItem = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(index + 1));
                this.selectItem(nextItem);
            }
        } else if (index == 1) {
            BreadcrumbItem root = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(0));
            root.openDropDownMenu();
            root.getDropDownShell().setFocus();
        } else {
            this.selectItem((BreadcrumbItem)((Object)this.fBreadcrumbItems.get(index - 1)));
        }
    }

    protected int buildItemChain(Object element) {
        BreadcrumbItem item;
        if (element == null) {
            return 0;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        Object parent = contentProvider.getParent(element);
        if (parent == element) {
            return 0;
        }
        int index = this.buildItemChain(parent);
        if (index < this.fBreadcrumbItems.size()) {
            item = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(index));
            if (item.getData() != null) {
                this.unmapElement(item.getData());
            }
        } else {
            item = this.createItem();
            this.fBreadcrumbItems.add(item);
        }
        if (element != null && this.equals(element, item.getData())) {
            this.update(element, null);
        } else {
            item.setData(element);
            item.refresh();
        }
        if (parent == null) {
            item.setDetailsVisible(true);
            item.setShowText(false);
            this.rootItem = item;
        }
        this.mapElement(element, (Widget)item);
        return index + 1;
    }

    private BreadcrumbItem createItem() {
        BreadcrumbItem result = new BreadcrumbItem(this, this.fContainer);
        result.setLabelProvider((IBreadcrumbLabelProvider)this.getLabelProvider());
        result.setContentProvider((ITreeContentProvider)this.getContentProvider());
        return result;
    }

    private boolean updateSize() {
        boolean requiresLayout;
        block8: {
            int currentWidth;
            int width;
            block7: {
                width = this.fContainer.getClientArea().width;
                currentWidth = this.getCurrentWidth();
                requiresLayout = false;
                if (currentWidth <= width) break block7;
                int index = 0;
                while (currentWidth > width && index < this.fBreadcrumbItems.size() - 1) {
                    BreadcrumbItem viewer = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(index));
                    if (viewer.isShowText()) {
                        viewer.setShowText(false);
                        currentWidth = this.getCurrentWidth();
                        requiresLayout = true;
                    }
                    ++index;
                }
                break block8;
            }
            if (currentWidth >= width) break block8;
            int index = this.fBreadcrumbItems.size() - 1;
            while (currentWidth < width && index >= 0) {
                BreadcrumbItem viewer = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(index));
                if (!viewer.isShowText()) {
                    if (viewer != this.rootItem) {
                        viewer.setShowText(true);
                    }
                    if ((currentWidth = this.getCurrentWidth()) > width) {
                        viewer.setShowText(false);
                        index = 0;
                    } else {
                        requiresLayout = true;
                    }
                }
                --index;
            }
        }
        return requiresLayout;
    }

    private int getCurrentWidth() {
        int result = 0;
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem viewer = (BreadcrumbItem)((Object)this.fBreadcrumbItems.get(i));
            result += viewer.getWidth();
            ++i;
        }
        return result;
    }

    private void enableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.fContainer.setRedraw(true);
    }

    private void disableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.fContainer.setRedraw(false);
    }

    private Image createGradientImage(int height, Display display) {
        int width = 50;
        Image result = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)result);
        Color colorC = this.createColor(22, 25, 35, display);
        Color colorD = this.createColor(22, 25, 45, display);
        Color colorE = this.createColor(22, 25, 80, display);
        Color colorF = this.createColor(22, 25, 70, display);
        Color colorG = this.createColor(22, 1, 45, display);
        Color colorH = this.createColor(18, 25, 35, display);
        try {
            this.drawLine(width, 0, colorC, gc);
            this.drawLine(width, 1, colorC, gc);
            gc.setForeground(colorD);
            gc.setBackground(colorE);
            gc.fillGradientRectangle(0, 2, width, 10, true);
            gc.setBackground(colorE);
            gc.fillRectangle(0, 11, width, height - 4);
            this.drawLine(width, height - 3, colorF, gc);
            this.drawLine(width, height - 2, colorG, gc);
            this.drawLine(width, height - 1, colorH, gc);
        }
        finally {
            gc.dispose();
            colorC.dispose();
            colorD.dispose();
            colorE.dispose();
            colorF.dispose();
            colorG.dispose();
            colorH.dispose();
        }
        return result;
    }

    private void drawLine(int width, int position, Color color, GC gc) {
        gc.setForeground(color);
        gc.drawLine(0, position, width, position);
    }

    private Color createColor(int color1, int color2, int ratio, Display display) {
        RGB rgb1 = display.getSystemColor(color1).getRGB();
        RGB rgb2 = display.getSystemColor(color2).getRGB();
        RGB blend = FormColors.blend((RGB)rgb2, (RGB)rgb1, (int)ratio);
        return new Color((Device)display, blend);
    }
}

