/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal.preferences;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractPreferencePage
extends PropertyAndPreferencePage {
    protected IPreferenceStore doGetPreferenceStore() {
        ScopedPreferenceStore store;
        if (this.isProjectPreferencePage()) {
            IProject project = this.getProject();
            store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), Activator.getId());
        } else {
            store = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getId());
        }
        return store;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasProjectSpecificOptions(IProject project) {
        if (!this.isProjectPreferencePage()) {
            return false;
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), Activator.getId());
        IEclipsePreferences[] iEclipsePreferencesArray = store.getPreferenceNodes(false);
        int n = iEclipsePreferencesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEclipsePreferences prefs = iEclipsePreferencesArray[n2];
            try {
                HashSet keys = Sets.newHashSet((Object[])prefs.keys());
                String[] stringArray = this.getKeys();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String key = stringArray[n4];
                    if (keys.contains(key)) {
                        return true;
                    }
                    ++n4;
                }
            }
            catch (BackingStoreException e) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
    }

    protected abstract String[] getKeys();

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.isProjectPreferencePage() && !this.useProjectSettings()) {
            String[] stringArray = this.getKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                store.setToDefault(key);
                ++n2;
            }
        }
        try {
            if (store instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)store).save();
            }
        }
        catch (IOException e1) {
            XtendLog.logError(e1);
        }
        return super.performOk();
    }
}

