/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.m2e;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.xtend.core.compiler.XtendOutputConfigurationProvider;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.util.RuntimeIOException;
import org.osgi.service.prefs.BackingStoreException;

public class XtendProjectConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        XtendProjectConfigurator.addNature((IProject)request.getProject(), (String)"org.eclipse.xtext.ui.shared.xtextNature", (IProgressMonitor)monitor);
        OutputConfiguration config = (OutputConfiguration)new XtendOutputConfigurationProvider().getOutputConfigurations().iterator().next();
        List executions = this.getMojoExecutions(request, monitor);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)executions.size());
        for (MojoExecution execution : executions) {
            String goal = execution.getGoal();
            if (goal.equals("compile")) {
                this.readCompileConfig(config, request, execution, progress.split(1));
                continue;
            }
            if (goal.equals("testCompile")) {
                this.readTestCompileConfig(config, request, execution, progress.split(1));
                continue;
            }
            if (goal.equals("xtend-install-debug-info")) {
                this.readDebugInfoConfig(config, request, execution, progress.split(1));
                continue;
            }
            if (!goal.equals("xtend-test-install-debug-info")) continue;
            this.readTestDebugInfoConfig(config, request, execution, progress.split(1));
        }
        this.writePreferences(config, request.getProject());
    }

    private void writePreferences(OutputConfiguration configuration, IProject project) {
        ProjectScope projectPreferences = new ProjectScope(project);
        IEclipsePreferences languagePreferences = projectPreferences.getNode("org.eclipse.xtend.core.Xtend");
        languagePreferences.putBoolean(OptionsConfigurationBlock.isProjectSpecificPropertyKey((String)"BuilderConfiguration"), true);
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((OutputConfiguration)configuration, (String)"installDslAsPrimarySource"), configuration.isInstallDslAsPrimarySource());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((OutputConfiguration)configuration, (String)"hideLocalSyntheticVariables"), configuration.isHideSyntheticLocalVariables());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((OutputConfiguration)configuration, (String)"userOutputPerSourceFolder"), true);
        for (OutputConfiguration.SourceMapping sourceMapping : configuration.getSourceMappings()) {
            languagePreferences.put(BuilderPreferenceAccess.getOutputForSourceFolderKey((OutputConfiguration)configuration, (String)sourceMapping.getSourceFolder()), Strings.nullToEmpty((String)sourceMapping.getOutputDirectory()));
        }
        try {
            languagePreferences.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private void readCompileConfig(OutputConfiguration config, ProjectConfigurationRequest request, MojoExecution execution, SubMonitor progress) throws CoreException {
        List roots = request.getMavenProject().getCompileSourceRoots();
        progress = SubMonitor.convert((IProgressMonitor)progress, (int)roots.size());
        for (String source : roots) {
            OutputConfiguration.SourceMapping mapping = new OutputConfiguration.SourceMapping(this.makeProjectRelative(source, request));
            String outputDirectory = this.mojoParameterValue("outputDirectory", String.class, request, execution, progress);
            mapping.setOutputDirectory(this.makeProjectRelative(outputDirectory, request));
            config.getSourceMappings().add(mapping);
        }
    }

    private void readTestCompileConfig(OutputConfiguration config, ProjectConfigurationRequest request, MojoExecution execution, SubMonitor progress) throws CoreException {
        List roots = request.getMavenProject().getTestCompileSourceRoots();
        progress = SubMonitor.convert((IProgressMonitor)progress, (int)roots.size());
        for (String source : roots) {
            OutputConfiguration.SourceMapping mapping = new OutputConfiguration.SourceMapping(this.makeProjectRelative(source, request));
            String testOutputDirectory = this.mojoParameterValue("testOutputDirectory", String.class, request, execution, progress);
            mapping.setOutputDirectory(this.makeProjectRelative(testOutputDirectory, request));
            config.getSourceMappings().add(mapping);
        }
    }

    private String makeProjectRelative(String fileName, ProjectConfigurationRequest request) {
        File baseDir = request.getMavenProject().getBasedir();
        File file = new File(fileName);
        String relativePath = file.isAbsolute() ? baseDir.toURI().relativize(file.toURI()).getPath() : file.getPath();
        String unixDelimited = relativePath.replaceAll("\\\\", "/");
        return CharMatcher.is((char)'/').trimFrom((CharSequence)unixDelimited);
    }

    private void readDebugInfoConfig(OutputConfiguration config, ProjectConfigurationRequest request, MojoExecution execution, SubMonitor progress) throws CoreException {
        progress = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        config.setHideSyntheticLocalVariables(this.mojoParameterValue("hideSyntheticVariables", Boolean.class, request, execution, progress).booleanValue());
        config.setInstallDslAsPrimarySource(this.mojoParameterValue("xtendAsPrimaryDebugSource", Boolean.class, request, execution, progress).booleanValue());
    }

    private void readTestDebugInfoConfig(OutputConfiguration config, ProjectConfigurationRequest request, MojoExecution execution, SubMonitor progress) throws CoreException {
        progress = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        config.setHideSyntheticLocalVariables(this.mojoParameterValue("hideSyntheticVariables", Boolean.class, request, execution, progress).booleanValue());
        config.setInstallDslAsPrimarySource(this.mojoParameterValue("xtendAsPrimaryDebugSource", Boolean.class, request, execution, progress).booleanValue());
    }

    private <T> T mojoParameterValue(String paramName, Class<T> paramType, ProjectConfigurationRequest request, MojoExecution execution, SubMonitor progress) throws CoreException {
        return (T)this.maven.getMojoParameterValue(request.getMavenProject(), execution, paramName, paramType, (IProgressMonitor)progress.split(1));
    }
}

