/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.debugger.shell;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoTransportService;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.tools.shell.Main;

public final class DebugShell {
    public static final String DEFAULT_PORT = "9888";
    public static final String ARG_TRACE = "-trace";
    public static final String ARG_SUSPEND = "-suspend";
    public static final String ARG_PORT = "-port";

    public static void main(String[] args) {
        String port = DEFAULT_PORT;
        boolean suspend = false;
        boolean trace = true;
        ArrayList<String> argList = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (ARG_PORT.equals(arg)) {
                port = args[++i];
            } else if (ARG_SUSPEND.equals(arg)) {
                suspend = DebugShell.isSuspend(args[++i]);
            } else if (ARG_TRACE.equals(arg)) {
                trace = Boolean.valueOf(args[++i]);
            } else {
                argList.add(arg);
            }
            ++i;
        }
        String[] newArgs = argList.toArray(new String[0]);
        RhinoTransportService service = new RhinoTransportService();
        RhinoDebuggerImpl debugger = new RhinoDebuggerImpl((TransportService)service, port, suspend, trace);
        try {
            if (trace) {
                DebugShell.prettyPrintHeader(suspend, port);
            }
            debugger.start();
            Main.shellContextFactory.addListener((ContextFactory.Listener)debugger);
            Main.exec((String[])newArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void prettyPrintHeader(boolean suspended, String port) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Rhino debugger\n");
        buffer.append("Start at time: ").append(DebugShell.getStartAtDate());
        buffer.append("\nListening to socket on ");
        buffer.append("port: ").append(port);
        if (suspended) {
            buffer.append("\nStarted suspended - waiting for client resume...");
        }
        System.out.println(buffer.toString());
    }

    static String getStartAtDate() {
        try {
            return DateFormat.getDateTimeInstance(1, 1).format(Calendar.getInstance().getTime());
        }
        catch (Throwable throwable) {
            return "<unknown>";
        }
    }

    public static boolean isSuspend(String arg) {
        return Boolean.valueOf(arg) != false || "y".equals(arg.toLowerCase());
    }
}

