/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.boundary;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.rete.boundary.Disconnectable;
import org.eclipse.viatra.query.runtime.rete.boundary.InputConnector;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Network;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.BehaviorChangingMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;
import org.eclipse.viatra.query.runtime.rete.remote.Address;

public class ExternalInputEnumeratorNode
extends StandardNode
implements Disconnectable,
Receiver,
IQueryRuntimeContextListener {
    private IQueryRuntimeContext context = null;
    private IInputKey inputKey;
    private Tuple globalSeed;
    private InputConnector inputConnector;
    private Network network;
    private Address<? extends Receiver> myAddress = Address.of(this);
    private boolean parallelExecutionEnabled;
    protected final Mailbox mailbox;
    private final IQueryBackendContext qBackendContext;

    public ExternalInputEnumeratorNode(ReteContainer reteContainer) {
        super(reteContainer);
        this.network = reteContainer.getNetwork();
        this.inputConnector = this.network.getInputConnector();
        this.qBackendContext = this.network.getEngine().getBackendContext();
        this.mailbox = this.instantiateMailbox();
        reteContainer.registerClearable(this.mailbox);
    }

    protected Mailbox instantiateMailbox() {
        if (this.reteContainer.isDifferentialDataFlowEvaluation()) {
            return new TimelyMailbox(this, this.reteContainer);
        }
        return new BehaviorChangingMailbox(this, this.reteContainer);
    }

    @Override
    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public void connectThroughContext(ReteEngine engine, IInputKey inputKey, Tuple globalSeed) {
        this.inputKey = inputKey;
        this.globalSeed = globalSeed;
        this.setTag(inputKey);
        IQueryRuntimeContext context = engine.getRuntimeContext();
        if (!context.getMetaContext().isEnumerable(inputKey)) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " only applicable for enumerable input keys; received instead " + inputKey);
        }
        this.context = context;
        this.parallelExecutionEnabled = engine.isParallelExecutionEnabled();
        engine.addDisconnectable(this);
        context.addUpdateListener(inputKey, globalSeed, (IQueryRuntimeContextListener)this);
    }

    @Override
    public void disconnect() {
        if (this.context != null) {
            this.context.removeUpdateListener(this.inputKey, this.globalSeed, (IQueryRuntimeContextListener)this);
            this.context = null;
        }
    }

    protected Iterable<Tuple> getTuplesInternal() {
        Iterable tuples = null;
        if (this.context != null) {
            if (this.globalSeed == null) {
                tuples = this.context.enumerateTuples(this.inputKey, TupleMask.empty((int)this.inputKey.getArity()), (ITuple)Tuples.staticArityFlatTupleOf());
            } else {
                TupleMask mask = TupleMask.fromNonNullIndices((ITuple)this.globalSeed);
                tuples = this.context.enumerateTuples(this.inputKey, mask, (ITuple)mask.transform((ITuple)this.globalSeed));
            }
        }
        return tuples;
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        Iterable<Tuple> tuples = this.getTuplesInternal();
        if (tuples != null) {
            for (Tuple tuple : tuples) {
                collector.add(tuple);
            }
        }
    }

    @Override
    public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
        Iterable<Tuple> tuples = this.getTuplesInternal();
        if (tuples != null) {
            for (Tuple tuple : tuples) {
                collector.put(tuple, Timestamp.ZERO);
            }
        }
    }

    public void update(IInputKey key, Tuple update, boolean isInsertion) {
        if (this.parallelExecutionEnabled) {
            this.network.sendExternalUpdate(this.myAddress, ExternalInputEnumeratorNode.direction(isInsertion), update);
        } else {
            if (this.qBackendContext.areUpdatesDelayed()) {
                this.mailbox.postMessage(ExternalInputEnumeratorNode.direction(isInsertion), update, Timestamp.ZERO);
            } else {
                this.update(ExternalInputEnumeratorNode.direction(isInsertion), update, Timestamp.ZERO);
            }
            this.network.waitForReteTermination();
        }
    }

    private static Direction direction(boolean isInsertion) {
        return isInsertion ? Direction.INSERT : Direction.REVOKE;
    }

    @Override
    public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
        this.propagateUpdate(direction, updateElement, timestamp);
    }

    @Override
    public void appendParent(Supplier supplier) {
        throw new UnsupportedOperationException("Input nodes can't have parents");
    }

    @Override
    public void removeParent(Supplier supplier) {
        throw new UnsupportedOperationException("Input nodes can't have parents");
    }

    @Override
    public Collection<Supplier> getParents() {
        return Collections.emptySet();
    }

    public IInputKey getInputKey() {
        return this.inputKey;
    }

    public Tuple getGlobalSeed() {
        return this.globalSeed;
    }
}

