/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintInfo;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintInfoInferrer;
import org.eclipse.viatra.query.runtime.localsearch.planner.PlanState;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.OperationCostComparator;
import org.eclipse.viatra.query.runtime.matchers.backend.ResultProviderRequestor;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PApply;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PStart;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

public class LocalSearchRuntimeBasedStrategy {
    private final OperationCostComparator infoComparator = new OperationCostComparator();

    protected SubPlan convertPlan(Set<PVariable> initialBoundVariables, PlanState searchPlan) {
        PBody pBody = searchPlan.getAssociatedPBody();
        SubPlanFactory subPlanFactory = new SubPlanFactory(pBody);
        SubPlan plan = subPlanFactory.createSubPlan((POperation)new PStart(initialBoundVariables), new SubPlan[0]);
        List<PConstraintInfo> operations = searchPlan.getOperations();
        for (PConstraintInfo pConstraintPlanInfo : operations) {
            PConstraint pConstraint = pConstraintPlanInfo.getConstraint();
            plan = subPlanFactory.createSubPlan((POperation)new PApply(pConstraint), new SubPlan[]{plan});
        }
        return subPlanFactory.createSubPlan((POperation)new PProject(pBody.getSymbolicParameterVariables()), new SubPlan[]{plan});
    }

    protected PlanState plan(PBody pBody, Set<PVariable> initialBoundVariables, IQueryBackendContext context, ResultProviderRequestor resultProviderRequestor, LocalSearchHints configuration) {
        ICostFunction costFunction = configuration.getCostFunction();
        PConstraintInfoInferrer pConstraintInfoInferrer = new PConstraintInfoInferrer(configuration.isUseBase(), context, resultProviderRequestor, costFunction::apply);
        Set constraintSet = pBody.getConstraints();
        List<PConstraintInfo> constraintInfos = pConstraintInfoInferrer.createPConstraintInfos(constraintSet);
        List<Set<PVariable>> reachableBoundVariableSets = this.reachabilityAnalysis(pBody, constraintInfos);
        int k = configuration.getRowCount();
        PlanState searchPlan = this.calculateSearchPlan(pBody, initialBoundVariables, k, reachableBoundVariableSets, constraintInfos);
        return searchPlan;
    }

    private PlanState calculateSearchPlan(PBody pBody, Set<PVariable> initialBoundVariables, int k, List<Set<PVariable>> reachableBoundVariableSets, List<PConstraintInfo> allMaskInfos) {
        ArrayList<PConstraintInfo> allPotentialExtendInfos = new ArrayList<PConstraintInfo>();
        ArrayList<PConstraintInfo> allPotentialCheckInfos = new ArrayList<PConstraintInfo>();
        HashMap<PVariable, List<PConstraintInfo>> checkOpsByVariables = new HashMap<PVariable, List<PConstraintInfo>>();
        HashMap<PVariable, Collection> extendOpsByBoundVariables = new HashMap<PVariable, Collection>();
        for (PConstraintInfo op : allMaskInfos) {
            if (op.getFreeVariables().isEmpty()) {
                allPotentialCheckInfos.add(op);
                continue;
            }
            allPotentialExtendInfos.add(op);
            for (PVariable variable : op.getBoundVariables()) {
                extendOpsByBoundVariables.computeIfAbsent(variable, v -> new ArrayList()).add(op);
            }
        }
        Collections.sort(allPotentialCheckInfos, this.infoComparator);
        for (PConstraintInfo op : allPotentialCheckInfos) {
            for (PVariable variable : op.getBoundVariables()) {
                checkOpsByVariables.computeIfAbsent(variable, v -> new ArrayList()).add(op);
            }
        }
        Set<PVariable> boundVariables = initialBoundVariables;
        Sets.SetView freeVariables = Sets.difference((Set)pBody.getUniqueVariables(), initialBoundVariables);
        int variableCount = pBody.getUniqueVariables().size();
        int n = freeVariables.size();
        List<List<PlanState>> stateTable = this.initializeStateTable(k, n);
        PlanState initialState = new PlanState(pBody, boundVariables);
        initialState.updateExtends(allPotentialExtendInfos);
        initialState.applyChecks(allPotentialCheckInfos);
        stateTable.get(n).add(0, initialState);
        int i = n;
        while (i > 0) {
            int j = 0;
            while (j < k && j < stateTable.get(i).size()) {
                PlanState currentState = stateTable.get(i).get(j);
                for (PConstraintInfo constraintInfo : currentState.getPresentExtends()) {
                    PlanState newState = this.calculateNextState(currentState, constraintInfo);
                    newState.applyChecksBasedOnDelta(checkOpsByVariables);
                    if (currentState.getBoundVariables().size() == newState.getBoundVariables().size()) continue;
                    int i2 = variableCount - newState.getBoundVariables().size();
                    List<Integer> newIndices = this.determineIndices(stateTable, i2, newState, k);
                    int a = newIndices.get(0);
                    int c = newIndices.get(1);
                    if (!this.checkInsertCondition(stateTable.get(i2), newState, reachableBoundVariableSets, a, c, k)) continue;
                    this.updateExtends(newState, currentState, extendOpsByBoundVariables);
                    this.insert(stateTable, i2, newState, a, c, k);
                }
                ++j;
            }
            --i;
        }
        return stateTable.get(0).get(0);
    }

    private List<List<PlanState>> initializeStateTable(int k, int n) {
        ArrayList<List<PlanState>> stateTable = new ArrayList<List<PlanState>>();
        int i = 0;
        while (i <= n) {
            stateTable.add(new ArrayList());
            ++i;
        }
        return stateTable;
    }

    private void insert(List<List<PlanState>> stateTable, int idx, PlanState newState, int a, int c, int k) {
        stateTable.get(idx).add(c, newState);
        while (stateTable.get(idx).size() > k) {
            stateTable.set(idx, stateTable.get(idx).subList(0, k));
        }
    }

    private void updateExtends(PlanState newState, PlanState currentState, Map<PVariable, ? extends Collection<PConstraintInfo>> extendOpsByBoundVariables) {
        List<PConstraintInfo> presentExtends = currentState.getPresentExtends();
        newState.updateExtendsBasedOnDelta(presentExtends, extendOpsByBoundVariables);
    }

    private boolean checkInsertCondition(List<PlanState> list, PlanState newState, List<Set<PVariable>> reachableBoundVariableSets, int a, int c, int k) {
        boolean isBetterThanCurrent;
        boolean isAmongBestK = a == k && c < a;
        boolean bl = isBetterThanCurrent = a < k && c <= a;
        return isAmongBestK || isBetterThanCurrent;
    }

    private List<Integer> determineIndices(List<List<PlanState>> stateTable, int i2, PlanState newState, int k) {
        int a = k;
        int c = 0;
        ArrayList<Integer> acIndices = new ArrayList<Integer>();
        int j = 0;
        while (j < k) {
            if (j >= stateTable.get(i2).size()) break;
            PlanState stateInTable = stateTable.get(i2).get(j);
            if (newState.getBoundVariables().equals(stateInTable.getBoundVariables())) {
                a = j;
            }
            if (newState.getCost() >= stateInTable.getCost()) {
                c = j + 1;
            }
            ++j;
        }
        acIndices.add(a);
        acIndices.add(c);
        return acIndices;
    }

    private PlanState calculateNextState(PlanState currentState, PConstraintInfo constraintInfo) {
        return currentState.cloneWithApplied(constraintInfo);
    }

    private List<Set<PVariable>> reachabilityAnalysis(PBody pBody, List<PConstraintInfo> constraintInfos) {
        ArrayList<Set<PVariable>> reachableBoundVariableSets = new ArrayList<Set<PVariable>>();
        return reachableBoundVariableSets;
    }
}

