/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statesystem;

import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;

public class TmfAttributePool {
    private final ITmfStateSystemBuilder fSs;
    private final Integer fBaseQuark;
    private final Queue<@Nullable Integer> fAvailableQuarks;
    private final Set<Integer> fQuarksInUse = new TreeSet<Integer>();
    private int fCount = 0;

    public TmfAttributePool(ITmfStateSystemBuilder ss, Integer baseQuark) {
        this(ss, baseQuark, QueueType.FIFO);
    }

    public TmfAttributePool(ITmfStateSystemBuilder ss, Integer baseQuark, QueueType type) {
        this.fSs = ss;
        try {
            ss.getParentAttributeQuark(baseQuark.intValue());
            this.fBaseQuark = baseQuark;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("The quark used as base for the attribute pool does not exist");
        }
        switch (type) {
            case FIFO: {
                this.fAvailableQuarks = new LinkedList<Integer>();
                break;
            }
            case PRIORITY: {
                this.fAvailableQuarks = new PriorityQueue<Integer>();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong queue type");
            }
        }
    }

    public synchronized int getAvailable() {
        Integer quark = this.fAvailableQuarks.poll();
        if (quark == null) {
            quark = this.fSs.getQuarkRelativeAndAdd(this.fBaseQuark.intValue(), new String[]{String.valueOf(this.fCount)});
            ++this.fCount;
        }
        this.fQuarksInUse.add(quark);
        return quark;
    }

    public synchronized void recycle(int quark, long ts) {
        if (!this.fQuarksInUse.remove(quark)) {
            throw new IllegalArgumentException("Quark " + quark + " is not in use at time " + ts);
        }
        this.fSs.removeAttribute(ts, quark);
        this.fAvailableQuarks.add(quark);
    }

    public static enum QueueType {
        FIFO,
        PRIORITY;

    }
}

