/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class MemoryUsageTreeViewer
extends AbstractSelectTreeViewer {
    private boolean fFiltered = true;

    public MemoryUsageTreeViewer(Composite parent, String id) {
        super(parent, 2, id);
        this.setLabelProvider((IBaseLabelProvider)new MemoryLabelProvider());
    }

    @Deprecated
    protected @Nullable TimeQueryFilter getFilter(long start, long end, boolean isSelection) {
        return new FilterTimeQueryFilter(Long.min(start, end), Long.max(start, end), 2, this.fFiltered);
    }

    protected @NonNull Map<String, Object> getParameters(long start, long end, boolean isSelection) {
        return FetchParametersUtils.filteredTimeQueryToMap((FilterTimeQueryFilter)new FilterTimeQueryFilter(Long.min(start, end), Long.max(start, end), 2, this.fFiltered));
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> {
            Comparator<TmfGenericTreeEntry> compareTid = Comparator.comparingInt(c -> ((MemoryUsageTreeModel)c.getModel()).getTid());
            return ImmutableList.of((Object)MemoryUsageTreeViewer.createColumn((String)Messages.MemoryUsageTree_ColumnProcess, Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)MemoryUsageTreeViewer.createColumn((String)Messages.MemoryUsageTree_ColumnTID, compareTid), (Object)new TmfTreeColumnData(Messages.MemoryUsageTree_Legend));
        };
    }

    public void setFiltered(boolean isFiltered) {
        this.fFiltered = isFiltered;
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    private class MemoryLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        private MemoryLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof TmfGenericTreeEntry)) {
                return null;
            }
            TmfGenericTreeEntry obj = (TmfGenericTreeEntry)element;
            if (columnIndex == 0) {
                return obj.getName();
            }
            if (columnIndex == 1) {
                int tid = ((MemoryUsageTreeModel)obj.getModel()).getTid();
                if (tid < 0) {
                    return Messages.MemoryUsageTree_Total;
                }
                return Integer.toString(tid);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 2 && element instanceof TmfGenericTreeEntry) {
                TmfGenericTreeEntry entry = (TmfGenericTreeEntry)element;
                int tid = ((MemoryUsageTreeModel)entry.getModel()).getTid();
                if (entry.getParent() instanceof TmfGenericTreeEntry && MemoryUsageTreeViewer.this.isChecked(element)) {
                    return MemoryUsageTreeViewer.this.getLegendImage(String.valueOf(entry.getParent().getName()) + ':' + tid);
                }
                if (tid < 0) {
                    return MemoryUsageTreeViewer.this.getLegendImage(String.valueOf(entry.getName()) + ":total");
                }
            }
            return null;
        }
    }
}

