/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.core.logger.ILogger;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.registry.EclipseSystemLogger;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.model.ITMModelManager;

public class TMModelManager
implements ITMModelManager {
    private static final ITMModelManager INSTANCE = new TMModelManager();
    private final Map<IDocument, ITMModel> models = new HashMap<IDocument, ITMModel>();

    public static ITMModelManager getInstance() {
        return INSTANCE;
    }

    private TMModelManager() {
    }

    @Override
    public ITMModel connect(IDocument document) {
        Object model = this.models.get(document);
        if (model != null) {
            return model;
        }
        model = new TMDocumentModel(document, (ILogger)new EclipseSystemLogger("org.eclipse.tm4e.ui/debug/log/TMModelManager"));
        this.models.put(document, (ITMModel)model);
        return model;
    }

    @Override
    public void disconnect(IDocument document) {
        ITMModel model = this.models.remove(document);
        if (model != null) {
            model.dispose();
        }
    }
}

