/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCommitAttr
extends AbstractOperation {
    protected FSTreeNode fNode;
    protected IFileSystem.FileAttrs fAttributes;

    public OpCommitAttr(FSTreeNode node, IFileSystem.FileAttrs attrs) {
        this.fNode = node;
        this.fAttributes = attrs;
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), -1);
        final TCFOperationMonitor result = new TCFOperationMonitor();
        final IFileSystem fileSystem = this.fNode.getRuntimeModel().getFileSystem();
        if (fileSystem == null) {
            return result.setCancelled();
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!result.checkCancelled()) {
                    String path = OpCommitAttr.this.fNode.getLocation(true);
                    fileSystem.setstat(path, OpCommitAttr.this.fAttributes, new IFileSystem.DoneSetStat(){

                        public void doneSetStat(IToken token, IFileSystem.FileSystemException error) {
                            if (error != null) {
                                result.setError(Messages.OpCommitAttr_error_cannotSetAttributes, (Throwable)error);
                            } else {
                                (this).OpCommitAttr.this.fNode.setAttributes((this).OpCommitAttr.this.fAttributes, true);
                                result.setDone(null);
                            }
                        }
                    });
                }
            }
        });
        return result.waitDone(monitor);
    }

    @Override
    public String getName() {
        return String.valueOf(Messages.OpCommitAttr_name) + this.fNode.getName();
    }
}

