/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.refresh;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class CreateTreeTask
extends AbstractCommandTask {
    private TreeDescription description;
    private EObject semanticElement;
    private IProgressMonitor monitor;

    public CreateTreeTask(TreeDescription desc, EObject semanticElement, IProgressMonitor monitor) {
        this.semanticElement = semanticElement;
        this.description = desc;
        this.monitor = monitor;
    }

    public void execute() {
        if (this.semanticElement != null) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.semanticElement);
            String name = new IdentifiedElementQuery((IdentifiedElement)this.description).getLabel();
            if (!StringUtil.isEmpty((String)this.description.getTitleExpression())) {
                try {
                    name = interpreter.evaluateString(this.semanticElement, this.description.getTitleExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)this.description, (EStructuralFeature)DescriptionPackage.eINSTANCE.getRepresentationDescription_TitleExpression(), (Throwable)e);
                }
            }
            if (this.monitor == null) {
                this.monitor = new NullProgressMonitor();
            }
            DialectManager.INSTANCE.createRepresentation(name, this.semanticElement, (RepresentationDescription)this.description, SessionManager.INSTANCE.getSession(this.semanticElement), this.monitor);
        }
    }

    public String getLabel() {
        return null;
    }
}

