/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.viewers;

import java.lang.reflect.Field;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.exception.JFaceLayerException;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class CellEditor
implements ReferencedComposite {
    protected static final String COLUMN_VIEWER_ID = "org.eclipse.jface.columnViewer";
    protected TableItem tableItem;
    protected int index;

    public CellEditor(TableItem tableItem) {
        this(tableItem, 0);
    }

    public CellEditor(TableItem tableItem, int index) {
        this.tableItem = tableItem;
        this.index = index;
    }

    public void activate() {
        this.tableItem.click(this.index);
    }

    public void activateByDoubleClick() {
        this.tableItem.doubleClick(this.index);
    }

    public boolean isActivated() {
        return this.getControl() != null;
    }

    public void deactivate() {
        if (this.isActivated()) {
            WidgetHandler.getInstance().notifyWidget(16, (Widget)this.getControl());
        }
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public Control getControl() {
        org.eclipse.jface.viewers.CellEditor jFaceCellEditor = this.getJFaceCellEditor();
        if (jFaceCellEditor == null) {
            return null;
        }
        return jFaceCellEditor.getControl();
    }

    protected org.eclipse.jface.viewers.CellEditor getJFaceCellEditor() {
        return (org.eclipse.jface.viewers.CellEditor)Display.syncExec((ResultRunnable)new ResultRunnable<org.eclipse.jface.viewers.CellEditor>(){

            public org.eclipse.jface.viewers.CellEditor run() {
                org.eclipse.jface.viewers.CellEditor cellEditor = null;
                TableColumn col = ((Table)CellEditor.this.tableItem.getParent().getSWTWidget()).getColumn(CellEditor.this.index);
                Object colData = col.getData(CellEditor.COLUMN_VIEWER_ID);
                ViewerColumn viewCol = (ViewerColumn)colData;
                ColumnViewerEditor colViewerEditor = viewCol.getViewer().getColumnViewerEditor();
                try {
                    Field f = ColumnViewerEditor.class.getDeclaredField("cellEditor");
                    if (f == null) {
                        throw new JFaceLayerException("Cannot find a cell editor at index '" + CellEditor.this.index + "'. Probably you didn't activate it.");
                    }
                    f.setAccessible(true);
                    Object obj = f.get(colViewerEditor);
                    if (obj instanceof org.eclipse.jface.viewers.CellEditor) {
                        cellEditor = (org.eclipse.jface.viewers.CellEditor)obj;
                    }
                }
                catch (Exception e) {
                    throw new JFaceLayerException("Cannot find a cell editor.", e);
                }
                return cellEditor;
            }
        });
    }
}

