/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench.browser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class WebBrowserDialog
extends MessageDialog {
    private String text;
    private Browser browser;
    private Label statusLabel;
    private Text locationLabel;
    private boolean showLocation = true;
    private boolean showStatus = true;

    public WebBrowserDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.setShellStyle(1264);
    }

    public void setText(String text) {
        this.text = text;
        if (this.browser != null) {
            this.browser.setText(text);
        }
    }

    public String getText() {
        return this.text;
    }

    public boolean setUrl(String url, String postData, String[] headers) {
        return this.getBrowser().setUrl(url, postData, headers);
    }

    public static int openText(Shell parent, String title, String message, String text) {
        if (PlatformUiUtil.hasInternalBrowser()) {
            WebBrowserDialog dialog = new WebBrowserDialog(parent, title, null, message, 0, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.setText(text);
            return dialog.open();
        }
        File file = null;
        try {
            file = File.createTempFile("temp", ".html");
            file.deleteOnExit();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(message);
            }
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.commons.workbench", "Unexpected error while displaying page", (Throwable)e), 1);
            return 1;
        }
        BrowserUtil.openUrl(file.toURI().toString(), 128);
        return 0;
    }

    public Control createCustomArea(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        if (this.showLocation) {
            this.locationLabel = new Text(parent, 2056);
            this.locationLabel.setBackground(parent.getBackground());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.locationLabel);
        }
        this.browser = new Browser(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.browser);
        if (this.showStatus) {
            this.statusLabel = new Label(parent, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.statusLabel);
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    WebBrowserDialog.this.statusLabel.setText(event.text != null ? event.text : "");
                }
            });
        }
        if (this.showLocation) {
            this.browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                }

                public void changed(LocationEvent event) {
                    if (!event.top) {
                        return;
                    }
                    WebBrowserDialog.this.locationLabel.setText(event.location != null ? event.location : "");
                }
            });
        }
        if (this.text != null) {
            this.browser.setText(this.text);
        }
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    public boolean getShowLocation() {
        return this.showLocation;
    }

    public void setShowLocation(boolean showLocation) {
        if (this.locationLabel != null) {
            throw new IllegalStateException("Control already created");
        }
        this.showLocation = showLocation;
    }

    public boolean getShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(boolean showStatus) {
        if (this.statusLabel != null) {
            throw new IllegalStateException("Control already created");
        }
        this.showStatus = showStatus;
    }
}

