/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.binaryproject.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.binaryproject.internal.BinaryProjectPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;

public abstract class AbstractBinaryProjectsImportJob
extends Job {
    public AbstractBinaryProjectsImportJob() {
        super("Import binary projects");
    }

    protected IStatus run(IProgressMonitor monitor) {
        Collection<ArtifactKey> artifacts;
        try {
            artifacts = this.getArtifactKeys(monitor);
        }
        catch (CoreException e1) {
            return e1.getStatus();
        }
        if (!artifacts.isEmpty()) {
            ArrayList<IStatus> errors = new ArrayList<IStatus>();
            for (ArtifactKey artifact : artifacts) {
                try {
                    BinaryProjectPlugin.getInstance().create(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, monitor);
                }
                catch (CoreException e) {
                    errors.add(e.getStatus());
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected abstract Collection<ArtifactKey> getArtifactKeys(IProgressMonitor var1) throws CoreException;
}

