/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.providers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.CutToClipboardCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.commands.processes.RemoveActivityEdgeCommand;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.meta.providers.interfaces.ICommandProvider;
import org.eclipse.jwt.we.commands.WEDeleteCommand;
import org.eclipse.jwt.we.commands.WEDragAndDropCommand;
import org.eclipse.jwt.we.commands.clipboard.WECopyToClipboardCommand;
import org.eclipse.jwt.we.commands.clipboard.WECutToClipboardCommand;
import org.eclipse.jwt.we.commands.clipboard.WEPasteFromClipboardCommand;
import org.eclipse.jwt.we.commands.core.WERemovePackageElementsCommand;
import org.eclipse.jwt.we.commands.core.WERemovePackageSubpackagesCommand;
import org.eclipse.jwt.we.commands.processes.WERemoveActivityNodeCommand;
import org.eclipse.jwt.we.commands.view.CreateReferenceEdgeCommand;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.factories.CreateReferenceFactory;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.EdgeDirection;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.model.view.ViewPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModelCommandProvider
implements ICommandProvider {
    private WEEditor weeditor;

    public MetaModelCommandProvider(WEEditor weeditor) {
        this.weeditor = weeditor;
    }

    private Command createActionExecutedByPerformedBySetCommand(EditingDomain domain, Action action, EStructuralFeature referFeature, Object referElem) {
        if (referElem == null) {
            ReferenceEdge refEdge = EMFHelper.getReferenceEdgeForAction(this.weeditor, action, (ReferenceableElement)action.eGet(referFeature));
            return new DeleteCommand(domain, Collections.singleton(refEdge));
        }
        CompoundCommand createCommand = new CompoundCommand();
        Reference reference = EMFHelper.getReferenceForScope(this.weeditor, (Scope)action.eContainer(), (ReferenceableElement)referElem);
        if (reference == null) {
            reference = (Reference)new CreateReferenceFactory((ReferenceableElement)referElem).getNewObject();
            reference.setContainedIn((Scope)action.eContainer());
            LayoutDataManager.setX(this.weeditor, reference, LayoutDataManager.getX(this.weeditor, (GraphicalElement)action));
            LayoutDataManager.setY(this.weeditor, reference, LayoutDataManager.getY(this.weeditor, (GraphicalElement)action) - 80);
            createCommand.append(AddCommand.create((EditingDomain)domain, (Object)this.weeditor.getDiagramData(), (Object)ViewPackage.Literals.DIAGRAM__REFERENCES, Collections.singleton(reference)));
        }
        CreateReferenceEdgeCommand createRefEdgeCommand = new CreateReferenceEdgeCommand(this.weeditor, domain);
        createRefEdgeCommand.setSource(action);
        createRefEdgeCommand.setTarget(reference);
        createRefEdgeCommand.setDirection(0);
        createCommand.append((Command)createRefEdgeCommand);
        return createCommand;
    }

    private Command createActionInputsOutputsAddCommand(EditingDomain domain, Action action, EStructuralFeature referFeature, Collection<?> refElements) {
        CompoundCommand addEdgesCommand = new CompoundCommand();
        for (ReferenceableElement refElem : refElements) {
            Reference reference = null;
            ReferenceEdge refEdge = EMFHelper.getReferenceEdgeForAction(this.weeditor, action, refElem);
            if (refEdge != null) {
                reference = refEdge.getReference();
            }
            if (reference == null) {
                reference = EMFHelper.getReferenceForScope(this.weeditor, (Scope)action.eContainer(), refElem);
            }
            if (reference == null) {
                reference = (Reference)new CreateReferenceFactory(refElem).getNewObject();
                reference.setContainedIn((Scope)action.eContainer());
                LayoutDataManager.setX(this.weeditor, reference, LayoutDataManager.getX(this.weeditor, (GraphicalElement)action));
                LayoutDataManager.setY(this.weeditor, reference, LayoutDataManager.getY(this.weeditor, (GraphicalElement)action) - 80);
                addEdgesCommand.append(AddCommand.create((EditingDomain)domain, (Object)this.weeditor.getDiagramData(), (Object)ViewPackage.Literals.DIAGRAM__REFERENCES, Collections.singleton(reference)));
            }
            CreateReferenceEdgeCommand createRefEdgeCommand = new CreateReferenceEdgeCommand(this.weeditor, domain);
            createRefEdgeCommand.setSource(action);
            createRefEdgeCommand.setTarget(reference);
            if (referFeature == ProcessesPackage.Literals.ACTION__INPUTS) {
                createRefEdgeCommand.setDirection(0);
            } else {
                createRefEdgeCommand.setDirection(1);
            }
            addEdgesCommand.append((Command)createRefEdgeCommand);
        }
        return addEdgesCommand;
    }

    private Command createActionInputsOutputsRemoveCommand(EditingDomain domain, Action action, EStructuralFeature referFeature, Collection<?> refElements) {
        CompoundCommand removeEdgesCommand = new CompoundCommand();
        for (ReferenceableElement refElem : refElements) {
            ReferenceEdge refEdge = EMFHelper.getReferenceEdgeForAction(this.weeditor, action, refElem);
            removeEdgesCommand.append((Command)new DeleteCommand(domain, Collections.singleton(refEdge)));
            if (refEdge.getDirection() != EdgeDirection.INOUT) continue;
            CreateReferenceEdgeCommand createRefEdgeCommand = new CreateReferenceEdgeCommand(this.weeditor, domain);
            createRefEdgeCommand.setSource(refEdge.getAction());
            createRefEdgeCommand.setTarget(refEdge.getReference());
            createRefEdgeCommand.setSkipCanExecute(true);
            if (referFeature == ProcessesPackage.Literals.ACTION__INPUTS) {
                createRefEdgeCommand.setDirection(1);
            } else {
                createRefEdgeCommand.setDirection(0);
            }
            removeEdgesCommand.append((Command)createRefEdgeCommand);
        }
        return removeEdgesCommand;
    }

    public Command createProviderCommand(String commandType, EditingDomain domain, Object owner, EStructuralFeature feature, Object data) {
        if (commandType.equals("CT_SCOPE_ACTIVITYNODE_REMOVE")) {
            return new WERemoveActivityNodeCommand(this.weeditor, domain, (EObject)owner, feature, (Collection)data);
        }
        if (commandType.equals("CT_SCOPE_ACTIVITYEDGE_REMOVE")) {
            return new RemoveActivityEdgeCommand(domain, (EObject)owner, feature, (Collection)data);
        }
        if (commandType.equals("CT_PACKAGE_ELEMENTS_REMOVE")) {
            return new WERemovePackageElementsCommand(this.weeditor, domain, (EObject)owner, feature, (Collection)data);
        }
        if (commandType.equals("CT_PACKAGE_SUBPACKAGES_REMOVE")) {
            return new WERemovePackageSubpackagesCommand(this.weeditor, domain, (EObject)owner, feature, (Collection)data);
        }
        if (commandType.equals("CT_ACTION_EXECUTEDBYPERFORMEDBY_SET")) {
            return this.createActionExecutedByPerformedBySetCommand(domain, (Action)owner, feature, data);
        }
        if (commandType.equals("CT_ACTION_INPUTSOUTPUTS_ADD")) {
            return this.createActionInputsOutputsAddCommand(domain, (Action)owner, feature, (Collection)data);
        }
        if (commandType.equals("CT_ACTION_INPUTSOUTPUTS_REMOVE")) {
            return this.createActionInputsOutputsRemoveCommand(domain, (Action)owner, feature, (Collection)data);
        }
        return null;
    }

    public Command createCommand(AdapterFactoryEditingDomain domain, Class commandClass, CommandParameter commandParameter) {
        if (commandClass == CutToClipboardCommand.class) {
            return new WECutToClipboardCommand(this.weeditor, (EditingDomain)domain, RemoveCommand.create((EditingDomain)domain, (Object)commandParameter.getOwner(), (Object)commandParameter.getFeature(), (Collection)commandParameter.getCollection()));
        }
        if (commandClass == CopyToClipboardCommand.class) {
            return new WECopyToClipboardCommand(this.weeditor, (EditingDomain)domain, commandParameter.getCollection());
        }
        if (commandClass == PasteFromClipboardCommand.class) {
            return new WEPasteFromClipboardCommand(this.weeditor, (EditingDomain)domain, commandParameter.getOwner(), commandParameter.getFeature(), commandParameter.getIndex(), domain.getOptimizeCopy());
        }
        if (commandClass == DeleteCommand.class) {
            return new WEDeleteCommand(this.weeditor, (EditingDomain)domain, commandParameter.getCollection());
        }
        if (commandClass == DragAndDropCommand.class) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
            return new WEDragAndDropCommand(this.weeditor, (EditingDomain)domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection());
        }
        return null;
    }
}

