/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.TestCaseTreeComposite;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;

public class TestCaseTreeDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 2;
    private static final int MARGIN_HEIGHT = 2;
    private List<ISelectionListener> m_selectionListenerList = new ArrayList<ISelectionListener>();
    private String m_title = Messages.TestCaseTableDialogTitle;
    private String m_message = Messages.TestCaseTableDialogMessage;
    private String m_shellTitle = Messages.TestCaseTableDialogShellTitle;
    private String m_addButtonText = Messages.TestCaseTableDialogAdd;
    private ISpecTestCasePO m_parentTestCase;
    private ISelection m_lastSel;
    private int m_treeStyle = 4;
    private Button m_addButton;
    private Image m_image = IconConstants.ADD_TC_DIALOG_IMAGE;
    private boolean m_onlyCategories = false;
    private boolean m_reuseds = true;
    private Object m_preSelect = null;
    private String m_enterTextLabel = null;
    private String m_enteredText = null;
    private String m_presetText = null;
    private TestCaseTreeComposite m_testcaseTreeComposite;

    public TestCaseTreeDialog(Shell shell, ISpecTestCasePO parentTestCase, int treeStyle) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_parentTestCase = parentTestCase;
        this.m_treeStyle = treeStyle;
    }

    public TestCaseTreeDialog(Shell shell, String title, String message, ISpecTestCasePO parentTestCase, String shellTitle, int treeStyle, Image image) {
        this(shell, parentTestCase, treeStyle);
        this.m_title = title;
        this.m_message = message;
        this.m_shellTitle = shellTitle;
        this.m_image = image;
    }

    public TestCaseTreeDialog(Shell shell, String title, String message, ISpecTestCasePO parentTestCase, String shellTitle, int treeStyle, Image image, String addButtonText) {
        this(shell, title, message, parentTestCase, shellTitle, treeStyle, image);
        this.m_addButtonText = addButtonText;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.m_title);
        this.setMessage(this.m_message);
        this.getShell().setText(this.m_shellTitle);
        this.setTitleImage(this.m_image);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 2;
        gridLayoutParent.marginHeight = 2;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        if (this.m_enterTextLabel != null) {
            Composite textPar = new Composite(parent, 0);
            textPar.setLayoutData((Object)new GridData(4, 4, true, false));
            GridLayout gr = new GridLayout();
            gr.numColumns = 1;
            gr.marginWidth = 5;
            textPar.setLayout((Layout)gr);
            Label lab = new Label(textPar, 0);
            lab.setText(this.m_enterTextLabel);
            Text text = new Text(textPar, 2052);
            GridData dat = new GridData(4, 4, true, false);
            LayoutUtil.addToolTipAndMaxWidth((GridData)dat, (Control)text);
            text.setLayoutData((Object)dat);
            if (this.m_presetText != null) {
                text.setText(this.m_presetText);
                this.m_enteredText = this.m_presetText;
            }
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TestCaseTreeDialog.this.m_enteredText = ((Text)e.getSource()).getText();
                    TestCaseTreeDialog.this.m_addButton.setEnabled(TestCaseTreeDialog.this.checkDataValidityAndSetErrorMessage());
                }
            });
            LayoutUtil.createSeparator((Composite)parent);
        }
        this.m_testcaseTreeComposite = this.m_parentTestCase != null ? new TestCaseTreeComposite(parent, this.m_treeStyle, (INodePO)this.m_parentTestCase) : new TestCaseTreeComposite(parent, this.m_treeStyle, this.m_reuseds, this.m_onlyCategories);
        LayoutUtil.createSeparator((Composite)parent);
        return this.m_testcaseTreeComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String buttonText = this.m_addButtonText;
        if (this.m_onlyCategories) {
            buttonText = IDialogConstants.OK_LABEL;
        }
        this.m_addButton = this.createButton(parent, 0, buttonText, true);
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseTreeDialog.this.setReturnCode(0);
                TestCaseTreeDialog.this.close();
            }
        });
        TreeViewer tv = this.m_testcaseTreeComposite.getTreeViewer();
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection() != null && !e.getSelection().isEmpty()) {
                    TestCaseTreeDialog.this.m_lastSel = e.getSelection();
                    TestCaseTreeDialog.this.m_addButton.setEnabled(true);
                }
            }
        });
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestCaseTreeDialog.this.m_addButton.setEnabled(TestCaseTreeDialog.this.checkDataValidityAndSetErrorMessage());
            }
        });
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!TestCaseTreeDialog.this.m_addButton.getEnabled()) {
                    return;
                }
                TestCaseTreeDialog.this.notifyListener();
                TestCaseTreeDialog.this.setReturnCode(0);
                TestCaseTreeDialog.this.close();
            }
        });
        if (this.m_preSelect != null) {
            tv.getControl().setFocus();
            tv.setSelection((ISelection)new StructuredSelection(this.m_preSelect));
        }
        Button cancelButton = this.createButton(parent, 1, Messages.TestCaseTableDialogCancel, false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseTreeDialog.this.setReturnCode(1);
                TestCaseTreeDialog.this.close();
            }
        });
        this.m_addButton.setEnabled(this.checkDataValidityAndSetErrorMessage());
    }

    private boolean checkDataValidityAndSetErrorMessage() {
        boolean nameValid = true;
        if (this.m_enterTextLabel != null) {
            nameValid = InputDialog.validateTCName(this.m_enteredText);
            if (!nameValid) {
                this.setErrorMessage(Messages.RenameActionTCError);
            } else {
                this.setErrorMessage(null);
            }
        }
        return nameValid && this.m_testcaseTreeComposite.hasValidSelection();
    }

    public void addSelectionListener(ISelectionListener listener) {
        if (!this.m_selectionListenerList.contains(listener)) {
            this.m_selectionListenerList.add(listener);
        }
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.m_selectionListenerList.remove(listener);
    }

    void notifyListener() {
        this.m_lastSel = this.m_testcaseTreeComposite.getTreeViewer().getSelection();
        for (ISelectionListener listener : this.m_selectionListenerList) {
            listener.selectionChanged(null, this.m_lastSel);
        }
    }

    public void setOnlyCategories(boolean onlyCats) {
        this.m_onlyCategories = onlyCats;
    }

    public void setReuseds(boolean reuseds) {
        this.m_reuseds = reuseds;
    }

    public void setPreSelect(Object pre) {
        this.m_preSelect = pre;
    }

    public void setEnterTextLabel(String label, String preset) {
        this.m_enterTextLabel = label;
        this.m_presetText = preset;
    }

    public List<INodePO> getSelection() {
        ArrayList<INodePO> res = new ArrayList<INodePO>();
        if (this.m_lastSel instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)this.m_lastSel) {
                if (!(next instanceof INodePO)) continue;
                res.add((INodePO)next);
            }
        }
        return res;
    }

    public String getEnteredText() {
        return this.m_enteredText;
    }
}

