/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.util.gef.MouseWheelHorizontalScrollHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;

public class GraphitiScrollingGraphicalViewer
extends ScrollingGraphicalViewer {
    private DiagramBehavior diagramBehavior;

    public GraphitiScrollingGraphicalViewer(DiagramBehavior diagramBehavior) {
        this.setDiagramBehavior(diagramBehavior);
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), MouseWheelZoomHandler.SINGLETON);
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD2), MouseWheelHorizontalScrollHandler.SINGLETON);
    }

    public void select(EditPart editpart) {
        IToolBehaviorProvider tbp = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean connectionSelectionEnabled = tbp.isConnectionSelectionEnabled();
        Object model = editpart.getModel();
        if ((connectionSelectionEnabled || !(model instanceof Connection)) && model != null && model instanceof PictogramElement) {
            this.deselectAll();
            PictogramElement[] newSelection = tbp.getSelections((PictogramElement)model);
            if (newSelection != null) {
                ArrayList<EditPart> newEditPartSelections = new ArrayList<EditPart>();
                PictogramElement[] pictogramElementArray = newSelection;
                int n = newSelection.length;
                int n2 = 0;
                while (n2 < n) {
                    PictogramElement newSelectionElement = pictogramElementArray[n2];
                    EditPart newEditPart = (EditPart)this.getEditPartRegistry().get(newSelectionElement);
                    if (newEditPart != null) {
                        newEditPartSelections.add(newEditPart);
                    }
                    ++n2;
                }
                boolean firstSelect = true;
                for (EditPart newEditPart : newEditPartSelections) {
                    if (firstSelect) {
                        super.select(newEditPart);
                        firstSelect = false;
                        continue;
                    }
                    super.appendSelection(newEditPart);
                }
            }
        }
    }

    public void setSelection(ISelection newSelection) {
        IToolBehaviorProvider tbp = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean connectionSelectionPossible = tbp.isConnectionSelectionEnabled();
        boolean change = false;
        ArrayList<EditPart> selectionList = new ArrayList<EditPart>();
        if (newSelection instanceof IStructuredSelection) {
            IStructuredSelection strSel = (IStructuredSelection)newSelection;
            int i = 0;
            while (i < strSel.toArray().length) {
                EditPart editPart;
                Object modelObject;
                Object object = strSel.toArray()[i];
                if (object instanceof EditPart && (modelObject = (editPart = (EditPart)object).getModel()) instanceof PictogramElement && (connectionSelectionPossible || !(modelObject instanceof Connection))) {
                    PictogramElement[] models = tbp.getSelections((PictogramElement)modelObject);
                    if (models != null) {
                        PictogramElement[] pictogramElementArray = models;
                        int n = models.length;
                        int n2 = 0;
                        while (n2 < n) {
                            PictogramElement model = pictogramElementArray[n2];
                            EditPart modelEditPart = (EditPart)this.getEditPartRegistry().get(model);
                            if (modelEditPart != null && !selectionList.contains(modelObject)) {
                                selectionList.add(modelEditPart);
                                change = true;
                            }
                            ++n2;
                        }
                    } else if (tbp.isMultiSelectionEnabled() || selectionList.isEmpty()) {
                        selectionList.add(editPart);
                        change = true;
                    }
                }
                ++i;
            }
            if (!tbp.isMultiSelectionEnabled()) {
                this.deselectAll();
            }
        }
        if (change) {
            newSelection = new StructuredSelection(selectionList);
        }
        super.setSelection(newSelection);
    }

    public void appendSelection(EditPart editpart) {
        PictogramElement[] pes;
        IToolBehaviorProvider tbp = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        Object model = editpart.getModel();
        if (!tbp.isConnectionSelectionEnabled() && model instanceof Connection) {
            return;
        }
        if (!tbp.isMultiSelectionEnabled()) {
            this.deselectAll();
        }
        if (model instanceof PictogramElement && (pes = tbp.getSelections((PictogramElement)model)) != null) {
            PictogramElement[] pictogramElementArray = pes;
            int n = pes.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                EditPart editPart = (EditPart)this.getEditPartRegistry().get(pe);
                if (editPart != null) {
                    super.appendSelection(editPart);
                }
                ++n2;
            }
        }
    }

    private void setDiagramBehavior(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    protected DiagramBehavior getDiagramBehavior() {
        return this.diagramBehavior;
    }
}

