/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.highlighting;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Port;
import org.eclipse.gef.dot.internal.ui.language.highlighting.DotSubgrammarHighlighter;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;

public class DotSemanticHighlightingCalculator
extends DefaultSemanticHighlightingCalculator {
    public void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            EObject grammarElement = node.getGrammarElement();
            if (!(grammarElement instanceof RuleCall)) continue;
            RuleCall rc = (RuleCall)grammarElement;
            AbstractRule r = rc.getRule();
            EObject c = grammarElement.eContainer();
            if (r.getName().equals("ID") && ((Assignment)c).getFeature().equals("name")) {
                EObject semanticElement = node.getSemanticElement();
                if (semanticElement instanceof DotGraph) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"graph_name"});
                } else if (semanticElement instanceof NodeStmt || semanticElement instanceof NodeId) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"node_name"});
                } else if (semanticElement instanceof Attribute) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"attribute_name"});
                } else if (semanticElement instanceof Port) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"port_name"});
                }
            }
            if (r.getName().equals("EdgeOp")) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"edge_op"});
            }
            if (!r.getName().equals("HTML_STRING")) continue;
            this.provideHighlightingForHtmlString(node, acceptor);
        }
    }

    private void provideHighlightingForHtmlString(INode node, IHighlightedPositionAcceptor acceptor) {
        int openingSymbolOffset = node.getOffset();
        acceptor.addPosition(openingSymbolOffset, 1, new String[]{"html_tag"});
        int closingSymbolOffset = node.getOffset() + node.getText().length() - 1;
        acceptor.addPosition(closingSymbolOffset, 1, new String[]{"html_tag"});
        String htmlString = node.getText().substring(1, node.getText().length() - 1);
        DotSubgrammarHighlighter htmlLabelHighlighter = new DotSubgrammarHighlighter("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
        htmlLabelHighlighter.provideHightlightingFor(htmlString, node.getOffset() + 1, acceptor);
    }
}

