/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.log;

import java.io.StringWriter;
import org.cloudfoundry.client.lib.RestLogEntry;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.CloudTracer;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.core.internal.log.TraceType;

public class DefaultCloudTracer
extends CloudTracer {
    static final String HTTP_TRACE_STATUS = "HTTP STATUS";
    static final String HTTP_TRACE_REQUEST = "REQUEST";
    static final String ERROR_STATUS = "ERROR";
    static final String TRACE_SEPARATOR = " :: ";
    static final String SPACE = " ";

    @Override
    protected void doTrace(RestLogEntry restLogEntry) {
        StringWriter writer = new StringWriter();
        boolean isError = restLogEntry.getStatus() != null && ERROR_STATUS.equals(restLogEntry.getStatus());
        writer.append(restLogEntry.getStatus());
        writer.append(SPACE);
        writer.append(TRACE_SEPARATOR);
        writer.append(SPACE);
        writer.append(HTTP_TRACE_STATUS);
        writer.append(':');
        writer.append(SPACE);
        writer.append(restLogEntry.getHttpStatus().name());
        this.fireTraceEvent(this.getCloudLog(writer.toString(), isError ? TraceType.HTTP_ERROR : TraceType.HTTP_OK));
        writer = new StringWriter();
        writer.append(SPACE);
        writer.append(TRACE_SEPARATOR);
        writer.append(SPACE);
        writer.append(HTTP_TRACE_REQUEST);
        writer.append(':');
        writer.append(SPACE);
        writer.append(restLogEntry.getMethod().toString());
        writer.append(' ');
        writer.append(restLogEntry.getUri().toString());
        writer.append(TRACE_SEPARATOR);
        writer.append(restLogEntry.getMessage());
        writer.append('\n');
        this.fireTraceEvent(this.getCloudLog(writer.toString(), TraceType.HTTP_GENERAL));
    }

    protected CloudLog getCloudLog(String log, LogContentType type) {
        return new CloudLog(log, type);
    }
}

