/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.internal.ui.workingsets.CElementWorkingSetPageContentProvider;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class CElementWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.CElementWorkingSetPage_title;
    private static final String PAGE_ID = "CElementWorkingSetPage";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private IWorkingSet fWorkingSet;
    private boolean fFirstCheck;
    private ITreeContentProvider fTreeContentProvider;

    public CElementWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, CPluginImages.DESC_WIZABAN_C_APP);
        this.setDescription(WorkingSetMessages.CElementWorkingSetPage_description);
        this.fFirstCheck = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.CElementWorkingSetPage_name);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CElementWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.CElementWorkingSetPage_content);
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fTree = new CheckboxTreeViewer(composite);
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 50;
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTreeContentProvider = new CElementWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider cElementLabelProvider = new AppearanceAwareLabelProvider(1073742345L, 3);
        this.fTree.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(cElementLabelProvider));
        this.fTree.setSorter((ViewerSorter)new CElementSorter());
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)CoreModel.create((IWorkspaceRoot)CUIPlugin.getWorkspace().getRoot()));
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CElementWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (!CElementWorkingSetPage.this.fTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)CElementWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CElementWorkingSetPage.this.setSubtreeChecked(element, CElementWorkingSetPage.this.fTree.getChecked(element), false);
                        }
                    });
                }
            }
        });
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        ArrayList<Object> elements = new ArrayList<Object>(10);
        this.findCheckedElements(elements, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        } else {
            IAdaptable[] oldItems = this.fWorkingSet.getElements();
            HashSet<IProject> closedWithChildren = new HashSet<IProject>(elements.size());
            IAdaptable[] iAdaptableArray = oldItems;
            int n = oldItems.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IAdaptable oldItem = iAdaptableArray[n2];
                IResource oldResource = null;
                oldResource = oldItem instanceof IResource ? (IResource)oldItem : (IResource)oldItem.getAdapter(IResource.class);
                if (oldResource != null && !oldResource.isAccessible() && (closedWithChildren.contains(project = oldResource.getProject()) || elements.contains(project))) {
                    elements.add(oldItem);
                    elements.remove(project);
                    closedWithChildren.add(project);
                }
                ++n2;
            }
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                boolean state = event.getChecked();
                CElementWorkingSetPage.this.fTree.setGrayed((Object)element, false);
                if (CElementWorkingSetPage.this.isExpandable(element)) {
                    CElementWorkingSetPage.this.setSubtreeChecked(element, state, true);
                }
                CElementWorkingSetPage.this.updateParentState(element, state);
                CElementWorkingSetPage.this.validateInput();
            }
        });
    }

    private boolean isExpandable(Object element) {
        return element instanceof ICProject || element instanceof ICContainer || element instanceof CElementGrouping || element instanceof ICModel || element instanceof IContainer;
    }

    private void updateParentState(Object child, boolean baseChildState) {
        IResource resource;
        if (child == null) {
            return;
        }
        if (child instanceof IAdaptable && (resource = (IResource)((IAdaptable)child).getAdapter(IResource.class)) != null && !resource.isAccessible()) {
            return;
        }
        Object parent = this.fTreeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        this.updateObjectState(parent, baseChildState);
    }

    private void updateObjectState(Object element, boolean baseChildState) {
        boolean allSameState = true;
        Object[] children = this.fTreeContentProvider.getChildren(element);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.fTree.getChecked(children[i]) != baseChildState || this.fTree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.fTree.setGrayed(element, !allSameState);
        this.fTree.setChecked(element, !allSameState || baseChildState);
        this.updateParentState(element, baseChildState);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] elements;
                if (CElementWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage page = CUIPlugin.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IWorkbenchPart iWorkbenchPart = CUIPlugin.getActivePage().getActivePart();
                    if (iWorkbenchPart == null) {
                        return;
                    }
                    try {
                        elements = SelectionConverter.getStructuredSelection(iWorkbenchPart).toArray();
                        int i = 0;
                        while (i < elements.length) {
                            ICElement ce;
                            if (elements[i] instanceof IResource && (ce = (ICElement)((IResource)elements[i]).getAdapter(ICElement.class)) != null && ce.exists() && ce.getCProject().isOnSourceRoot((IResource)elements[i])) {
                                elements[i] = ce;
                            }
                            ++i;
                        }
                    }
                    catch (CModelException e) {
                        return;
                    }
                } else {
                    elements = CElementWorkingSetPage.this.fWorkingSet.getElements();
                }
                int i = 0;
                while (i < elements.length) {
                    ICProject cProject;
                    IAdaptable iAdaptable = elements[i];
                    if (iAdaptable instanceof IResource) {
                        ICElement cElement;
                        IProject project = ((IResource)iAdaptable).getProject();
                        if (!project.isAccessible()) {
                            elements[i] = project;
                        } else if (CoreModel.hasCNature((IProject)project) && (cElement = CoreModel.getDefault().create((IResource)iAdaptable)) != null) {
                            elements[i] = cElement;
                        }
                    } else if (iAdaptable instanceof ICElement && (cProject = ((ICElement)iAdaptable).getCProject()) != null && !cProject.getProject().isAccessible()) {
                        elements[i] = cProject.getProject();
                    }
                    ++i;
                }
                CElementWorkingSetPage.this.fTree.setCheckedElements(elements);
                HashSet<Object> parents = new HashSet<Object>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object parent;
                    IResource resource;
                    Object object = objectArray[n2];
                    if (CElementWorkingSetPage.this.isExpandable(object)) {
                        CElementWorkingSetPage.this.setSubtreeChecked(object, true, true);
                    }
                    if ((!(object instanceof IAdaptable) || (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) == null || resource.isAccessible()) && (parent = CElementWorkingSetPage.this.fTreeContentProvider.getParent(object)) != null) {
                        parents.add(parent);
                    }
                    ++n2;
                }
                for (Object e : parents) {
                    CElementWorkingSetPage.this.updateObjectState(e, true);
                }
            }
        });
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(workingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        if (!(parent instanceof IAdaptable)) {
            return;
        }
        IContainer container = (IContainer)((IAdaptable)parent).getAdapter(IContainer.class);
        if (!this.fTree.getExpandedState(parent) && checkExpandedState || container != null && !container.isAccessible()) {
            return;
        }
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.fTree.setChecked(element, true);
                this.fTree.setGrayed(element, false);
            } else {
                this.fTree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    void validateInput() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.CElementWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        if (newText.isEmpty()) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = WorkingSetMessages.CElementWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets;
            IWorkingSet[] iWorkingSetArray = workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                if (newText.equals(workingSet.getName())) {
                    errorMessage = WorkingSetMessages.CElementWorkingSetPage_warning_workingSetExists;
                }
                ++n2;
            }
        }
        if (errorMessage == null && this.fTree.getCheckedElements().length == 0) {
            String infoMessage = WorkingSetMessages.CElementWorkingSetPage_warning_resourceMustBeChecked;
            this.setMessage(infoMessage, 1);
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private void findCheckedElements(List<Object> checkedElements, Object parent) {
        Object[] children;
        Object[] objectArray = children = this.fTreeContentProvider.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.fTree.getGrayed(element)) {
                this.findCheckedElements(checkedElements, element);
            } else if (this.fTree.getChecked(element)) {
                checkedElements.add(element);
            }
            ++n2;
        }
    }
}

