/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ACPathEntry;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class ACExclusionFilterEntry
extends ACPathEntry
implements ICExclusionPatternPathEntry {
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private final IPath[] exclusionPatterns;
    char[][] fullCharExclusionPatterns = UNINIT_PATTERNS;

    ACExclusionFilterEntry(IPath path, IPath[] exclusionPatterns, int flags) {
        super(path, flags);
        this.exclusionPatterns = exclusionPatterns != null ? (IPath[])exclusionPatterns.clone() : new IPath[]{};
    }

    ACExclusionFilterEntry(IFolder rc, IPath[] exclusionPatterns, int flags) {
        super((IResource)rc, flags);
        this.exclusionPatterns = exclusionPatterns != null ? (IPath[])exclusionPatterns.clone() : new IPath[]{};
    }

    ACExclusionFilterEntry(String value, IPath[] exclusionPatterns, int flags) {
        super(value, flags);
        this.exclusionPatterns = exclusionPatterns != null ? (IPath[])exclusionPatterns.clone() : new IPath[]{};
    }

    @Override
    public final boolean isFile() {
        return false;
    }

    @Override
    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns.length != 0 ? (IPath[])this.exclusionPatterns.clone() : this.exclusionPatterns;
    }

    @Override
    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[length][];
            IPath path = this.getFullPath();
            if (path == null) {
                path = this.getLocation();
            }
            IPath prefixPath = path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullCharExclusionPatterns[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullCharExclusionPatterns;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACExclusionFilterEntry other = (ACExclusionFilterEntry)obj;
        return Arrays.equals(this.exclusionPatterns, other.exclusionPatterns);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.exclusionPatterns);
        return result;
    }

    @Override
    public boolean equalsByContents(ICSettingEntry entry) {
        if (!super.equalsByContents(entry)) {
            return false;
        }
        ACExclusionFilterEntry otherEntry = (ACExclusionFilterEntry)entry;
        return Arrays.equals(this.exclusionPatterns, otherEntry.exclusionPatterns);
    }

    @Override
    protected String contentsToString() {
        String result = super.contentsToString();
        if (this.exclusionPatterns.length != 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(result);
            buf.append(" ; exclude: ");
            int i = 0;
            while (i < this.exclusionPatterns.length) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.exclusionPatterns[i].toString());
                ++i;
            }
            result = buf.toString();
        }
        return result;
    }
}

