/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.actions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DoNotGenerateFilesAction
implements IObjectActionDelegate {
    private IStructuredSelection structuredSelection;

    public void run(IAction action) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Object next : this.structuredSelection) {
            if (!(next instanceof IResource)) continue;
            resources.add((IResource)next);
        }
        final ArrayList<IFile> files = new ArrayList<IFile>();
        for (IResource iResource : resources) {
            if (iResource instanceof IFile) {
                files.add((IFile)iResource);
                continue;
            }
            if (!(iResource instanceof IContainer)) continue;
            IContainer iContainer = (IContainer)iResource;
            try {
                iContainer.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile) {
                            files.add((IFile)resource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
        ArrayListMultimap projects2files = ArrayListMultimap.create();
        for (IFile iFile : files) {
            projects2files.put((Object)iFile.getProject(), (Object)iFile);
        }
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress((Multimap)projects2files){
            private final /* synthetic */ Multimap val$projects2files;
            {
                this.val$projects2files = multimap;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Set projects = this.val$projects2files.keySet();
                for (IProject iProject : projects) {
                    StringBuffer buffer = new StringBuffer();
                    Collection filesNotToGenerate = this.val$projects2files.get((Object)iProject);
                    for (IFile fileNotToGenerate : filesNotToGenerate) {
                        buffer.append(fileNotToGenerate.getFullPath() + System.getProperty("line.separator"));
                    }
                    try {
                        IFile doNotGenerateFile = iProject.getFile(".do_not_generate");
                        if (doNotGenerateFile.exists()) {
                            doNotGenerateFile.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, true, monitor);
                            continue;
                        }
                        doNotGenerateFile.create((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, monitor);
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            AcceleoUIActivator.log(e, true);
        }
        catch (InterruptedException e) {
            AcceleoUIActivator.log(e, true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

