/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.spotify.docker.client.messages.swarm.AutoValue_PortConfig;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class PortConfig {
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_UDP = "udp";

    @Nullable
    @JsonProperty(value="Name")
    public abstract String name();

    @Nullable
    @JsonProperty(value="Protocol")
    public abstract String protocol();

    @Nullable
    @JsonProperty(value="TargetPort")
    public abstract Integer targetPort();

    @Nullable
    @JsonProperty(value="PublishedPort")
    public abstract Integer publishedPort();

    @Nullable
    @JsonProperty(value="PublishMode")
    public abstract PortConfigPublishMode publishMode();

    public static Builder builder() {
        return new AutoValue_PortConfig.Builder();
    }

    @JsonCreator
    static PortConfig create(@JsonProperty(value="Name") String name, @JsonProperty(value="Protocol") String protocol, @JsonProperty(value="TargetPort") Integer targetPort, @JsonProperty(value="PublishedPort") Integer publishedPort, @JsonProperty(value="PublishMode") PortConfigPublishMode publishMode) {
        return PortConfig.builder().name(name).protocol(protocol).targetPort(targetPort).publishedPort(publishedPort).publishMode(publishMode).build();
    }

    public static abstract class Builder {
        public abstract Builder name(String var1);

        @Deprecated
        public Builder withName(String name) {
            this.name(name);
            return this;
        }

        public abstract Builder protocol(String var1);

        @Deprecated
        public Builder withProtocol(String protocol) {
            this.protocol(protocol);
            return this;
        }

        public abstract Builder targetPort(Integer var1);

        @Deprecated
        public Builder withTargetPort(Integer targetPort) {
            this.targetPort(targetPort);
            return this;
        }

        public abstract Builder publishedPort(Integer var1);

        @Deprecated
        public Builder withPublishedPort(Integer publishedPort) {
            this.publishedPort(publishedPort);
            return this;
        }

        public abstract Builder publishMode(PortConfigPublishMode var1);

        public abstract PortConfig build();
    }

    public static enum PortConfigPublishMode {
        INGRESS("ingress"),
        HOST("host");

        private final String name;

        @JsonCreator
        private PortConfigPublishMode(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }
    }
}

