/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SSBP9704
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public SSBP9704(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                throw new AssertionNotApplicableException();
            }
            Element elem = doc.getDocumentElement();
            if (!elem.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") || !elem.getLocalName().equals("Envelope")) {
                throw new AssertionNotApplicableException();
            }
            String incorrectElementName = this.getIncorrectElementName(elem);
            if (incorrectElementName != null) {
                throw new AssertionFailException("The name of an element containing such namespace declaration is \"" + incorrectElementName + "\".");
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String getIncorrectElementName(Element elem) {
        String attrValue = elem.getAttributeNS("http://www.w3.org/2000/xmlns/", "xml");
        if ("http://www.w3.org/XML/1998/namespace".equals(attrValue)) {
            return elem.getNodeName();
        }
        Element child = XMLUtils.getFirstChild(elem);
        while (child != null) {
            String name = this.getIncorrectElementName(child);
            if (name != null) {
                return name;
            }
            child = XMLUtils.getNextSibling(child);
        }
        return null;
    }
}

