/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.runtime.emf.rules.ITransformationRule;

public class TransformationRuleGroup<Rule extends ITransformationRule<?, ?>>
extends HashSet<Rule> {
    private static final long serialVersionUID = 7057984500208333710L;

    public TransformationRuleGroup() {
    }

    @SafeVarargs
    public TransformationRuleGroup(Rule ... rules) {
        super(rules.length);
        Rule[] RuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = RuleArray[n2];
            this.add(rule);
            ++n2;
        }
    }

    public Set<RuleSpecification<?>> getRuleSpecifications() {
        return this.stream().filter(Objects::nonNull).map(ITransformationRule::getRuleSpecification).collect(Collectors.toSet());
    }

    public Map<RuleSpecification<?>, Set<EventFilter<?>>> getFilteredRuleMap() {
        HashMap map = new HashMap();
        for (ITransformationRule element : this) {
            RuleSpecification spec = element.getRuleSpecification();
            EventFilter filter = element.getFilter() != null ? element.getFilter() : spec.createEmptyFilter();
            map.computeIfAbsent(spec, sp -> new HashSet()).add(filter);
        }
        return map;
    }
}

