/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.data;

import java.math.BigDecimal;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRange;

public class ChartRangeMap {
    private static final int BIG_DECIMAL_DIVISION_SCALE = 22;
    private ChartRange fPlottedRange;
    private ChartRange fInputDataRange;

    public ChartRangeMap() {
        this.fPlottedRange = new ChartRange();
        this.fInputDataRange = new ChartRange();
    }

    public ChartRangeMap(ChartRange input) {
        this.fPlottedRange = new ChartRange();
        this.fInputDataRange = input;
    }

    public ChartRangeMap(ChartRange plotted, ChartRange input) {
        this.fPlottedRange = plotted;
        this.fInputDataRange = input;
    }

    public ChartRange getPlottedRange() {
        return this.fPlottedRange;
    }

    public ChartRange getInputDataRange() {
        return this.fInputDataRange;
    }

    public void setPlottedRange(ChartRange plotted) {
        this.fPlottedRange = plotted;
    }

    public void setInputDataRange(ChartRange input) {
        this.fInputDataRange = input;
    }

    public Number getInternalValue(Number number) {
        BigDecimal value = new BigDecimal(number.toString());
        ChartRange internal = this.getPlottedRange();
        ChartRange external = this.getInputDataRange();
        if (external.getDelta().compareTo(BigDecimal.ZERO) == 0) {
            return internal.getMinimum().doubleValue();
        }
        BigDecimal internalValue = value.subtract(external.getMinimum()).multiply(internal.getDelta()).divide(external.getDelta(), 22, 1).add(internal.getMinimum());
        return (Number)NonNullUtils.checkNotNull((Object)internalValue);
    }

    public BigDecimal getExternalValue(Number number) {
        ChartRange internal = this.getPlottedRange();
        ChartRange external = this.getInputDataRange();
        if (internal.getDelta().compareTo(BigDecimal.ZERO) == 0) {
            return external.getMinimum();
        }
        BigDecimal externalValue = new BigDecimal(number.toString()).subtract(internal.getMinimum()).multiply(external.getDelta()).divide(internal.getDelta(), 22, 1).add(external.getMinimum());
        return (BigDecimal)NonNullUtils.checkNotNull((Object)externalValue);
    }

    public String toString() {
        return "ChartRangeMap: Input Data -> " + this.fInputDataRange + ", Plotted -> " + this.fPlottedRange + "]";
    }
}

