/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class AlternateUserValidationDialog
extends Dialog {
    String user;
    String password = "";
    List numXs = new ArrayList();
    Label icon1;
    Label icon2;
    Label icon3;
    Label icon4;
    Text passwordText;
    boolean inUpdate = false;
    Image[] images;

    public AlternateUserValidationDialog(Shell parentShell, String user) {
        super(parentShell);
        this.user = user;
        this.initializeImages();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CVSUIMessages.AlternateUserValidationDialog_Enter_Password_2);
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Composite iconComposite = new Composite(main, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        iconComposite.setLayout((Layout)layout);
        iconComposite.setLayoutData((Object)new GridData());
        this.icon1 = this.createLabel(iconComposite);
        this.icon2 = this.createLabel(iconComposite);
        this.icon3 = this.createLabel(iconComposite);
        this.icon4 = this.createLabel(iconComposite);
        Composite middleComposite = new Composite(main, 0);
        middleComposite.setLayout((Layout)new GridLayout());
        middleComposite.setLayoutData((Object)new GridData());
        Label l = new Label(middleComposite, 0);
        l.setText(NLS.bind((String)CVSUIMessages.AlternateUserValidationDialog_message, (Object[])new String[]{this.user}));
        l.setLayoutData((Object)new GridData());
        l = new Label(middleComposite, 0);
        l.setText("");
        l.setLayoutData((Object)new GridData());
        this.passwordText = new Text(middleComposite, 2052);
        GridData data = new GridData();
        data.widthHint = 250;
        this.passwordText.setLayoutData((Object)data);
        this.passwordText.addVerifyListener(e -> {
            if (this.inUpdate) {
                return;
            }
            e.doit = false;
            this.inUpdate = true;
            switch (e.character) {
                case '\b': {
                    if (this.password.length() > 0) {
                        this.password = this.password.substring(0, this.password.length() - 1);
                    }
                    int numX = (Integer)this.numXs.get(this.numXs.size() - 1);
                    this.numXs.remove(this.numXs.size() - 1);
                    String oldText1 = this.passwordText.getText();
                    String newText1 = oldText1.substring(0, oldText1.length() - numX);
                    this.passwordText.setText(newText1);
                    this.passwordText.setSelection(newText1.length());
                    break;
                }
                default: {
                    String oldText2 = this.passwordText.getText();
                    String x = this.getXs();
                    this.numXs.add(this.numXs.size(), x.length());
                    String newText2 = String.valueOf(oldText2) + x;
                    this.passwordText.setText(newText2);
                    this.passwordText.setSelection(newText2.length());
                    this.password = String.valueOf(this.password) + e.character;
                }
            }
            this.inUpdate = false;
            this.updateImages();
        });
        Composite buttonComposite = new Composite(main, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData());
        Button b = new Button(buttonComposite, 8);
        b.setText(CVSUIMessages.AlternateUserValidationDialog_OK_6);
        data = new GridData();
        data.widthHint = 70;
        b.setLayoutData((Object)data);
        b.addListener(13, event -> this.okPressed());
        buttonComposite.getShell().setDefaultButton(b);
        b = new Button(buttonComposite, 8);
        b.setText(CVSUIMessages.AlternateUserValidationDialog_Cancel_7);
        data = new GridData();
        data.widthHint = 70;
        b.setLayoutData((Object)data);
        b.addListener(13, event -> this.cancelPressed());
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    public boolean close() {
        boolean result = super.close();
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                this.images[i].dispose();
                this.images[i] = null;
                ++i;
            }
            this.images = null;
        }
        return result;
    }

    public String getPassword() {
        return this.password;
    }

    Label createLabel(Composite parent) {
        Label result = new Label(parent, 0);
        GridData data = new GridData();
        data.widthHint = 22;
        data.heightHint = 22;
        result.setLayoutData((Object)data);
        result.setImage(this.getImage());
        return result;
    }

    Image getImage() {
        double random = Math.random();
        long num = Math.round(random *= 7.0);
        return this.images[(int)num];
    }

    void initializeImages() {
        this.images = new Image[8];
        int i = 0;
        while (i < this.images.length) {
            this.images[i] = CVSUIPlugin.getPlugin().getImageDescriptor("glyphs/glyph" + (i + 1) + ".gif").createImage();
            ++i;
        }
        FontData fd = new FontData();
        fd.setStyle(1);
        fd.setHeight(10);
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            fd.setName("Microsoft Sans Serif");
        }
    }

    void updateImages() {
        this.icon1.setImage(this.getImage());
        this.icon2.setImage(this.getImage());
        this.icon3.setImage(this.getImage());
        this.icon4.setImage(this.getImage());
    }

    public void setUsername(String user) {
        this.user = user;
    }

    String getXs() {
        double random = Math.random();
        random *= 2.0;
        long num = Math.round(random += 2.0);
        switch ((int)num) {
            case 2: {
                return "XX";
            }
            case 3: {
                return "XXX";
            }
            case 4: {
                return "XXXX";
            }
        }
        return "X";
    }

    protected void cancelPressed() {
        this.password = null;
        super.cancelPressed();
    }
}

