/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.query;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.internal.query.CustomizationQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionKey;
import org.eclipse.sirius.diagram.business.internal.query.VSMElementCustomizationQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.description.Customization;
import org.eclipse.sirius.viewpoint.description.EStructuralFeatureCustomization;
import org.eclipse.sirius.viewpoint.description.VSMElementCustomization;
import org.eclipse.sirius.viewpoint.description.VSMElementCustomizationReuse;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class StyleDescriptionQuery {
    private StyleDescription styleDescription;

    public StyleDescriptionQuery(StyleDescription styleDescription) {
        this.styleDescription = styleDescription;
    }

    public Map<EStructuralFeatureCustomization, Set<EObject>> getEStructuralFeatureCustomizationAppliedOn(BestStyleDescriptionKey bestStyleDescriptionKey, IInterpreter interpreter) {
        LinkedHashMap<EStructuralFeatureCustomization, Set<EObject>> eStructuralFeatureCustomizationsAppliedOn = new LinkedHashMap<EStructuralFeatureCustomization, Set<EObject>>();
        DDiagram dDiagram = bestStyleDescriptionKey.getDDiagram();
        for (Layer layer : dDiagram.getActivatedLayers()) {
            Customization customization = layer.getCustomization();
            if (customization == null) continue;
            Map<EStructuralFeatureCustomization, Set<EObject>> collectedEStructuralFeatureCustomizationsForCurrentLayer = this.collectEStructuralFeatureCustomizations(customization);
            for (Map.Entry<EStructuralFeatureCustomization, Set<EObject>> entry : collectedEStructuralFeatureCustomizationsForCurrentLayer.entrySet()) {
                EStructuralFeatureCustomization featureCustomization = entry.getKey();
                Set<EObject> value = entry.getValue();
                Set appliedOn = (Set)eStructuralFeatureCustomizationsAppliedOn.get(featureCustomization);
                if (appliedOn == null) {
                    eStructuralFeatureCustomizationsAppliedOn.put(featureCustomization, value);
                    continue;
                }
                appliedOn.addAll(value);
            }
        }
        Map<EStructuralFeatureCustomization, Set<EObject>> enaledFeatureCostumizations = this.getEnabledEStructuralFeatureCustomizations(eStructuralFeatureCustomizationsAppliedOn, bestStyleDescriptionKey, interpreter);
        return enaledFeatureCostumizations;
    }

    private Map<EStructuralFeatureCustomization, Set<EObject>> collectEStructuralFeatureCustomizations(Customization customization) {
        Set<Object> appliedOn;
        LinkedHashMap<EStructuralFeatureCustomization, Set<EObject>> eStructuralFeatureCustomizationsAppliedOn = new LinkedHashMap<EStructuralFeatureCustomization, Set<EObject>>();
        CustomizationQuery customizationQuery = new CustomizationQuery(customization);
        List vsmElementCustomizations = customizationQuery.getVSMElementCustomizations();
        for (VSMElementCustomization vsmElementCustomization : vsmElementCustomizations) {
            EList featureCustomizations = vsmElementCustomization.getFeatureCustomizations();
            for (EStructuralFeatureCustomization featureCustomization : featureCustomizations) {
                if (!featureCustomization.isApplyOnAll() && !this.isAppliedOnOrOwnedContent((List<EObject>)featureCustomization.getAppliedOn())) continue;
                appliedOn = (LinkedHashSet<EObject>)eStructuralFeatureCustomizationsAppliedOn.get(featureCustomization);
                if (appliedOn == null) {
                    appliedOn = new LinkedHashSet<EObject>();
                    eStructuralFeatureCustomizationsAppliedOn.put(featureCustomization, appliedOn);
                }
                if (featureCustomization.isApplyOnAll()) {
                    this.addStyleDescriptionAndAllSubStyles(appliedOn);
                    continue;
                }
                appliedOn.addAll((Collection<EObject>)featureCustomization.getAppliedOn());
            }
        }
        List vsmElementCustomizationReuses = customizationQuery.getVSMElementCustomzationReuses();
        for (VSMElementCustomizationReuse vsmElementCustomizationReuse : vsmElementCustomizationReuses) {
            if (!this.isAppliedOnOrOwnedContent((List<EObject>)vsmElementCustomizationReuse.getAppliedOn())) continue;
            for (EStructuralFeatureCustomization featureCustomization : vsmElementCustomizationReuse.getReuse()) {
                appliedOn = (Set)eStructuralFeatureCustomizationsAppliedOn.get(featureCustomization);
                if (appliedOn == null) {
                    appliedOn = new LinkedHashSet();
                    eStructuralFeatureCustomizationsAppliedOn.put(featureCustomization, appliedOn);
                }
                appliedOn.addAll((Collection<EObject>)vsmElementCustomizationReuse.getAppliedOn());
            }
        }
        return eStructuralFeatureCustomizationsAppliedOn;
    }

    private void addStyleDescriptionAndAllSubStyles(Set<EObject> appliedOn) {
        appliedOn.add((EObject)this.styleDescription);
        Iterators.addAll(appliedOn, (Iterator)this.styleDescription.eAllContents());
    }

    private boolean isAppliedOnOrOwnedContent(List<EObject> appliedOn) {
        boolean isAppliedOnOrOwnedContent = appliedOn.contains(this.styleDescription);
        if (!isAppliedOnOrOwnedContent) {
            TreeIterator styleDescriptionAllContents = this.styleDescription.eAllContents();
            while (styleDescriptionAllContents.hasNext()) {
                EObject styleDescriptionSubElt = (EObject)styleDescriptionAllContents.next();
                if (!appliedOn.contains(styleDescriptionSubElt)) continue;
                isAppliedOnOrOwnedContent = true;
                break;
            }
        }
        return isAppliedOnOrOwnedContent;
    }

    private Map<EStructuralFeatureCustomization, Set<EObject>> getEnabledEStructuralFeatureCustomizations(Map<EStructuralFeatureCustomization, Set<EObject>> eStructuralFeatureCustomizationsAppliedOn, BestStyleDescriptionKey bestStyleDescriptionKey, IInterpreter interpreter) {
        HashMap<VSMElementCustomization, Boolean> enabledVSMElementCustomizations = new HashMap<VSMElementCustomization, Boolean>();
        LinkedHashMap<EStructuralFeatureCustomization, Set<EObject>> enaledFeatureCostumizations = new LinkedHashMap<EStructuralFeatureCustomization, Set<EObject>>();
        for (Map.Entry<EStructuralFeatureCustomization, Set<EObject>> entry : eStructuralFeatureCustomizationsAppliedOn.entrySet()) {
            EStructuralFeatureCustomization featureCustomization = entry.getKey();
            Set<EObject> appliedOn = entry.getValue();
            EObject eContainer = featureCustomization.eContainer();
            if (enabledVSMElementCustomizations.containsKey(eContainer)) {
                if (!((Boolean)enabledVSMElementCustomizations.get(eContainer)).booleanValue()) continue;
                enaledFeatureCostumizations.put(featureCustomization, appliedOn);
                continue;
            }
            if (!(eContainer instanceof VSMElementCustomization)) continue;
            VSMElementCustomization vsmElementCustomization = (VSMElementCustomization)eContainer;
            VSMElementCustomizationQuery vsmElementCustomizationQuery = new VSMElementCustomizationQuery(vsmElementCustomization);
            boolean enabled = vsmElementCustomizationQuery.isEnabled(this.styleDescription, bestStyleDescriptionKey, interpreter);
            enabledVSMElementCustomizations.put(vsmElementCustomization, enabled);
            if (!enabled) continue;
            enaledFeatureCostumizations.put(featureCustomization, appliedOn);
        }
        return enaledFeatureCostumizations;
    }

    public DiagramDescription getDiagramDescription() {
        DiagramDescription diagramDescription = null;
        StyleDescription container = this.styleDescription;
        while (!(container instanceof DiagramDescription) && container != null) {
            container = container.eContainer();
        }
        if (container instanceof Layer) {
            diagramDescription = (DiagramDescription)container;
        }
        return diagramDescription;
    }
}

