/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;
import org.eclipse.sirius.common.tools.api.interpreter.IVariableStatusListener;
import org.eclipse.sirius.common.tools.api.interpreter.TypedValidation;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableManager;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.internal.assist.ContentContextHelper;
import org.eclipse.sirius.common.tools.internal.assist.ProposalProviderRegistry;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public final class CompoundInterpreter
implements IInterpreter,
IProposalProvider,
TypedValidation,
IInterpreterWithDiagnostic {
    public static final CompoundInterpreter INSTANCE = new CompoundInterpreter();
    private static final String ENGINE_ATTRIBUTE_CLASS = "interpreterProviderClass";
    private static final String INTERPRETER_EXTENSION_POINT = "org.eclipse.sirius.common.expressionInterpreter";
    private static final String TAG_ENGINE = "expressionInterpreterProvider";
    private final Map<IInterpreterProvider, IInterpreter> providers;
    private final Map<IInterpreterProvider, String> interpreterIdentifiers;
    private final VariableManager variableManager;
    private Collection<MetamodelDescriptor> additionalMetamodels = new LinkedHashSet<MetamodelDescriptor>();
    private final List<String> dependencies;
    private ModelAccessor modelAccessor;
    private final List<IVariableStatusListener> listeners;
    private ECrossReferenceAdapter crossReferencer;
    private boolean extensionsLoaded;
    private Map<Object, Object> properties;

    private CompoundInterpreter() {
        this.providers = new HashMap<IInterpreterProvider, IInterpreter>();
        this.variableManager = new VariableManager();
        this.dependencies = new LinkedList<String>();
        this.listeners = new ArrayList<IVariableStatusListener>();
        this.interpreterIdentifiers = new HashMap<IInterpreterProvider, String>();
        this.properties = new HashMap<Object, Object>();
    }

    public static IInterpreter createGenericInterpreter() {
        return new CompoundInterpreter();
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.evaluate(target, expression);
    }

    @Override
    public IInterpreterWithDiagnostic.IEvaluationResult evaluateExpression(EObject target, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        if (interpreter instanceof IInterpreterWithDiagnostic) {
            return ((IInterpreterWithDiagnostic)((Object)interpreter)).evaluateExpression(target, expression);
        }
        final Object result = interpreter.evaluate(target, expression);
        IInterpreterWithDiagnostic.IEvaluationResult evaluationResult = new IInterpreterWithDiagnostic.IEvaluationResult(){

            @Override
            public Object getValue() {
                return result;
            }

            @Override
            public Diagnostic getDiagnostic() {
                return Diagnostic.OK_INSTANCE;
            }
        };
        return evaluationResult;
    }

    @Override
    public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.evaluateBoolean(context, expression);
    }

    @Override
    public EObject evaluateEObject(EObject target, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.evaluateEObject(target, expression);
    }

    @Override
    public Integer evaluateInteger(EObject target, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.evaluateInteger(target, expression);
    }

    @Override
    public Collection<EObject> evaluateCollection(EObject target, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.evaluateCollection(target, expression);
    }

    @Override
    public String evaluateString(EObject target, String expression) throws EvaluationException {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.evaluateString(target, expression);
    }

    @Override
    public boolean provides(String expression) {
        return this.getProviderForExpression(expression) != null;
    }

    public IInterpreterProvider getProviderForExpression(String expression) {
        for (IInterpreterProvider provider : this.getProviders()) {
            if (!provider.provides(expression)) continue;
            return provider;
        }
        return DefaultInterpreterProvider.INSTANCE;
    }

    public String getInterpreterID(IInterpreter interpreter) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && interpreter != null) {
            IInterpreterProvider interpreterProvider = null;
            Iterator<Map.Entry<IInterpreterProvider, IInterpreter>> entryIterator = this.providers.entrySet().iterator();
            while (interpreterProvider == null && entryIterator.hasNext()) {
                Map.Entry<IInterpreterProvider, IInterpreter> entry = entryIterator.next();
                if (entry.getValue() == interpreter) {
                    interpreterProvider = entry.getKey();
                    continue;
                }
                if (entry.getValue() == null || entry.getValue().getClass() != interpreter.getClass()) continue;
                interpreterProvider = entry.getKey();
            }
            if (interpreterProvider != null) {
                return this.interpreterIdentifiers.get(interpreterProvider);
            }
        }
        return null;
    }

    public IInterpreter getInterpreterForExpression(String expression) {
        IInterpreter result = null;
        IInterpreterProvider provider = this.getProviderForExpression(expression);
        if (provider != null && (result = this.providers.get(provider)) == null) {
            result = provider.createInterpreter();
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                result.setProperty(entry.getKey(), entry.getValue());
            }
            result.activateMetamodels(this.additionalMetamodels);
            this.variableManager.setVariables(result);
            for (String dependency : this.dependencies) {
                result.addImport(dependency);
            }
            result.setModelAccessor(this.modelAccessor);
            for (IVariableStatusListener listener : this.listeners) {
                result.addVariableStatusListener(listener);
            }
            if (this.crossReferencer != null) {
                result.setCrossReferencer(this.crossReferencer);
            }
            if (provider != DefaultInterpreterProvider.INSTANCE) {
                this.providers.put(provider, result);
            }
        }
        return result;
    }

    public Set<IInterpreterProvider> getProviders() {
        if (!this.extensionsLoaded) {
            this.loadExtensions();
        }
        return this.providers.keySet();
    }

    public void registerProvider(IInterpreterProvider provider) {
        if (!this.getProviders().contains(provider)) {
            this.providers.put(provider, null);
        }
    }

    public void removeInterpreter(IInterpreterProvider provider) {
        this.providers.remove(provider);
    }

    private void loadExtensions() {
        this.parseExtensionMetadata();
        this.extensionsLoaded = true;
    }

    private void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(INTERPRETER_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    IInterpreterProvider desc = this.parseEngine(configElement);
                    if (desc != null) {
                        this.providers.put(desc, null);
                        this.interpreterIdentifiers.put(desc, extension.getUniqueIdentifier());
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private IInterpreterProvider parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        IInterpreterProvider desc = null;
        try {
            desc = (IInterpreterProvider)configElement.createExecutableExtension(ENGINE_ATTRIBUTE_CLASS);
        }
        catch (CoreException e) {
            DslCommonPlugin.getDefault().error(MessageFormat.format(Messages.CompoundInterpreter_impossibleToCreateInterpreter, configElement.getAttribute(ENGINE_ATTRIBUTE_CLASS)), e);
        }
        return desc;
    }

    @Override
    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
        this.additionalMetamodels.addAll(metamodels);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.activateMetamodels(metamodels);
        }
    }

    @Override
    public void addImport(String dependency) {
        this.dependencies.add(dependency);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.addImport(dependency);
        }
    }

    @Override
    public void clearImports() {
        this.dependencies.clear();
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.clearImports();
        }
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.setProperty(key, value);
        }
    }

    @Override
    public void clearVariables() {
        this.variableManager.clearVariables();
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.clearVariables();
        }
    }

    @Override
    public void dispose() {
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.dispose();
        }
        this.variableManager.clearVariables();
        this.dependencies.clear();
        this.providers.clear();
        this.properties.clear();
        this.additionalMetamodels.clear();
        this.extensionsLoaded = false;
        this.modelAccessor = null;
    }

    @Override
    public Object getVariable(String name) {
        return this.variableManager.getVariable(name);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.variableManager.setVariable(name, value);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.setVariable(name, value);
        }
    }

    @Override
    public void unSetVariable(String name) {
        this.variableManager.unSetVariable(name);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.unSetVariable(name);
        }
    }

    @Override
    public void addVariableStatusListener(IVariableStatusListener newListener) {
        this.listeners.add(newListener);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.addVariableStatusListener(newListener);
        }
    }

    @Override
    public Map<String, ?> getVariables() {
        Map<String, Object> result = this.variableManager.getVariables();
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            for (Map.Entry<String, ?> entry : interpreter.getVariables().entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    @Override
    public void removeVariableStatusListener(IVariableStatusListener listener) {
        this.listeners.remove(listener);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.removeVariableStatusListener(listener);
        }
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
        this.modelAccessor = modelAccessor;
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.setModelAccessor(modelAccessor);
        }
    }

    @Override
    public List<ContentProposal> getProposals(IInterpreter extendedInterpreter, ContentContext context) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        IInterpreter interpreter = this.getInterpreterForExpression(context.getContents());
        if (interpreter != null) {
            if (interpreter instanceof IProposalProvider) {
                proposals.addAll(((IProposalProvider)((Object)interpreter)).getProposals(interpreter, context));
            }
            List<IProposalProvider> proposalProviders = ProposalProviderRegistry.getProvidersFor(interpreter);
            for (IProposalProvider provider : proposalProviders) {
                proposals.addAll(provider.getProposals(interpreter, context));
            }
            if (interpreter == DefaultInterpreterProvider.INSTANCE) {
                proposals.addAll(this.getEmptyExpressionProposals(context.getContents()));
            }
        }
        return proposals;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public ContentProposal getNewEmtpyExpression() {
        return null;
    }

    public List<ContentProposal> getAllNewEmtpyExpressions() {
        ArrayList<ContentProposal> prefixes = new ArrayList<ContentProposal>();
        List<IProposalProvider> proposalProviders = ProposalProviderRegistry.getAllProviders();
        for (IProposalProvider provider : proposalProviders) {
            ContentProposal newEmtpyExpressionProposal = provider.getNewEmtpyExpression();
            if (newEmtpyExpressionProposal == null) continue;
            prefixes.add(newEmtpyExpressionProposal);
        }
        return prefixes;
    }

    @Override
    public String getVariablePrefix() {
        return null;
    }

    public String getVariablePrefix(String expression) {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.getVariablePrefix();
    }

    public List<String> getAllPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (IInterpreterProvider interpreterProvider : this.getProviders()) {
            if (interpreterProvider == null) continue;
            IInterpreter interpreter = interpreterProvider.createInterpreter();
            prefixes.add(interpreter.getPrefix());
        }
        prefixes.trimToSize();
        return prefixes;
    }

    @Override
    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
        this.crossReferencer = crossReferencer;
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.setCrossReferencer(crossReferencer);
        }
    }

    @Override
    public List<ContentProposal> getProposals(IInterpreter extendedInterpreter, ContentInstanceContext context) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        IInterpreter interpreterForExpression = this.getInterpreterForExpression(context.getTextSoFar());
        if (interpreterForExpression != null) {
            if (interpreterForExpression instanceof IProposalProvider) {
                proposals.addAll(((IProposalProvider)((Object)interpreterForExpression)).getProposals(interpreterForExpression, context));
            }
            List<IProposalProvider> proposalProviders = ProposalProviderRegistry.getProvidersFor(interpreterForExpression);
            for (IProposalProvider provider : proposalProviders) {
                proposals.addAll(provider.getProposals(interpreterForExpression, context));
            }
            if (interpreterForExpression == DefaultInterpreterProvider.INSTANCE) {
                proposals.addAll(this.getEmptyExpressionProposals(context.getTextSoFar()));
            }
        }
        return proposals;
    }

    @Override
    public Collection<String> getImports() {
        return Collections.unmodifiableCollection(this.dependencies);
    }

    @Override
    public void removeImport(String dependency) {
        this.dependencies.remove(dependency);
        for (IInterpreter interpreter : this.providers.values()) {
            if (interpreter == null) continue;
            interpreter.removeImport(dependency);
        }
    }

    @Override
    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        return interpreter.validateExpression(context, expression);
    }

    @Override
    public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
        IInterpreter interpreter = this.getInterpreterForExpression(expression);
        if (interpreter instanceof TypedValidation) {
            return ((TypedValidation)((Object)interpreter)).analyzeExpression(context, expression);
        }
        ValidationResult result = new ValidationResult();
        result.addAllStatus(interpreter.validateExpression(context, expression));
        return result;
    }

    @Override
    public boolean supportsValidation() {
        return true;
    }

    private List<ContentProposal> getEmptyExpressionProposals(String context) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        List<IProposalProvider> proposalProviders = ProposalProviderRegistry.getAllProviders();
        for (IProposalProvider provider : proposalProviders) {
            ContentProposal emptyExpression = provider.getNewEmtpyExpression();
            if (!StringUtil.isEmpty(context) && !ContentContextHelper.matchEmptyExpression(context, emptyExpression)) continue;
            proposals.add(emptyExpression);
        }
        return proposals;
    }

    private static class DefaultInterpreterProvider
    implements IInterpreterProvider,
    IInterpreter,
    TypedValidation {
        public static final DefaultInterpreterProvider INSTANCE = new DefaultInterpreterProvider();

        private DefaultInterpreterProvider() {
        }

        @Override
        public IInterpreter createInterpreter() {
            return this;
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean provides(String expression) {
            return true;
        }

        @Override
        public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
        }

        @Override
        public void addImport(String dependency) {
        }

        @Override
        public void addVariableStatusListener(IVariableStatusListener newListener) {
        }

        @Override
        public void clearImports() {
        }

        @Override
        public void clearVariables() {
        }

        @Override
        public Object evaluate(EObject target, String expression) throws EvaluationException {
            Integer result = this.evaluateInteger(target, expression);
            if (result != null) {
                return result;
            }
            return expression;
        }

        @Override
        public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
            return Boolean.parseBoolean(expression);
        }

        @Override
        public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
            return Collections.emptyList();
        }

        @Override
        public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
            return context;
        }

        @Override
        public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
            try {
                return new Integer(expression);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        public String evaluateString(EObject context, String expression) throws EvaluationException {
            return expression;
        }

        @Override
        public Object getVariable(String name) {
            return null;
        }

        public Map<String, Object> getVariables() {
            return Collections.emptyMap();
        }

        @Override
        public void removeVariableStatusListener(IVariableStatusListener listener) {
        }

        @Override
        public void setModelAccessor(ModelAccessor modelAccessor) {
        }

        @Override
        public void setProperty(Object key, Object value) {
        }

        @Override
        public void setVariable(String name, Object value) {
        }

        @Override
        public void unSetVariable(String name) {
        }

        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public String getVariablePrefix() {
            return null;
        }

        @Override
        public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
        }

        @Override
        public Collection<String> getImports() {
            return Collections.emptyList();
        }

        @Override
        public void removeImport(String dependency) {
        }

        @Override
        public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
            return new LinkedHashSet<IInterpreterStatus>();
        }

        @Override
        public boolean supportsValidation() {
            return false;
        }

        @Override
        public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
            return new ValidationResult();
        }
    }
}

