/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.generator.egf.xwt.reporter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.execution.EclipseFileReporter;

public class ViewReporter
extends EclipseFileReporter {
    public void executionFinished(String output, PatternContext context) {
    }

    public void loopFinished(String output, String outputWithCallBack, PatternContext context, Map<String, Object> parameterValues) {
        if (context.getValue("dataform.content") != null) {
            return;
        }
        IPath targetFilePath = (IPath)context.getValue("targetFile");
        if (targetFilePath != null && output != null && !"".equals(output)) {
            targetFilePath = targetFilePath.makeAbsolute();
            String targetFile = targetFilePath.toString();
            this.writeOutput(output, targetFilePath.removeLastSegments(1).toString(), targetFile);
        }
    }

    protected void writeOutput(String output, String targetDirectory, String targetFile) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            ViewReporter.ensureContainerExists((String)targetDirectory, (NullProgressMonitor)monitor);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(targetFile));
            if (file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(output.getBytes()), 2, (IProgressMonitor)monitor);
            } else {
                file.create((InputStream)new ByteArrayInputStream(output.getBytes()), true, (IProgressMonitor)monitor);
            }
        }
        catch (Exception exception) {
            EGFPatternPlugin.getDefault().logError((Throwable)exception);
        }
    }
}

