/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.messages.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.preferences.CustomDiagramGeneralPreferencePage;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateExecutionSpecificationWithMessage
extends AbstractTransactionalCommand {
    protected CreateConnectionViewAndElementRequest request;
    protected EditPart graphicalContainer;
    protected String preference;
    protected IHintedType type;
    protected boolean createReply;

    public CreateExecutionSpecificationWithMessage(TransactionalEditingDomain domain, CreateConnectionViewAndElementRequest request, EditPart graphicalContainer) {
        super(domain, Messages.Commands_CreateExecutionSpecification_Label, null);
        this.request = request;
        this.graphicalContainer = graphicalContainer;
        this.createReply = false;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Message message = this.getMessage();
        if (message == null) {
            throw new ExecutionException("null message");
        }
        this.retrievePreferences();
        if (this.type == null || "CHOICE_NONE".equals(this.preference)) {
            throw new ExecutionException("undefined preference");
        }
        this.createExecutionSpecification();
        return CommandResult.newOKCommandResult();
    }

    private void createExecutionSpecification() {
        ExecutionSpecification executionSpecification;
        LifelineEditPart lifelineEditPart = (LifelineEditPart)this.graphicalContainer;
        CreateViewRequest requestcreation = CreateViewRequestFactory.getCreateShapeRequest((IElementType)this.type, (PreferencesHint)lifelineEditPart.getDiagramPreferencesHint());
        Point point = this.request.getLocation().getCopy();
        requestcreation.setLocation(point);
        org.eclipse.gef.commands.Command command = lifelineEditPart.getCommand((Request)requestcreation);
        command.execute();
        if (this.createReply && (executionSpecification = this.getCreatedElement(command, ExecutionSpecification.class)) != null) {
            Point replysourcepoint = point.getCopy();
            replysourcepoint.setY(replysourcepoint.y + CustomActionExecutionSpecificationEditPart.DEFAULT_HEIGHT);
            this.createReplyMessage(lifelineEditPart, executionSpecification, replysourcepoint);
        }
    }

    private void createReplyMessage(LifelineEditPart lifelineEditPart, ExecutionSpecification executionSpecification, Point replysourcepoint) {
        CreateConnectionViewRequest requestreplycreation = CreateViewRequestFactory.getCreateConnectionRequest((IElementType)UMLDIElementTypes.MESSAGE_REPLY_EDGE, (PreferencesHint)lifelineEditPart.getDiagramPreferencesHint());
        requestreplycreation.setLocation(replysourcepoint);
        requestreplycreation.setSourceEditPart(null);
        requestreplycreation.setTargetEditPart((EditPart)lifelineEditPart);
        requestreplycreation.setType((Object)"connection start");
        org.eclipse.gef.commands.Command replycommand = lifelineEditPart.getCommand((Request)requestreplycreation);
        requestreplycreation.setSourceEditPart((EditPart)lifelineEditPart);
        NodeEditPart target = (NodeEditPart)this.request.getSourceEditPart();
        while (target instanceof AbstractExecutionSpecificationEditPart) {
            target = (NodeEditPart)target.getParent();
        }
        requestreplycreation.setTargetEditPart((EditPart)target);
        requestreplycreation.setType((Object)"connection end");
        IPapyrusNodeFigure f = target.getPrimaryShape();
        Rectangle b = f.getBounds().getCopy();
        f.translateToAbsolute((Translatable)b);
        Point c = b.getCenter().getCopy();
        Point replytargetpoint = replysourcepoint.getCopy();
        replytargetpoint.setX(c.x);
        requestreplycreation.setLocation(replytargetpoint);
        replycommand = target.getCommand((Request)requestreplycreation);
        replycommand.execute();
        Message messageReply = this.getCreatedElement(replycommand, Message.class);
        if (messageReply != null) {
            MessageEnd sendEvent = messageReply.getSendEvent();
            OccurrenceSpecification finish = executionSpecification.getFinish();
            SetCommand setSendEventCommand = new SetCommand((EditingDomain)this.getEditingDomain(), (EObject)executionSpecification, (EStructuralFeature)UMLPackage.eINSTANCE.getExecutionSpecification_Finish(), (Object)sendEvent);
            setSendEventCommand.execute();
            DestroyElementPapyrusCommand destroyElementPapyrusCommand = new DestroyElementPapyrusCommand(new DestroyElementRequest((EObject)finish, false));
            if (destroyElementPapyrusCommand != null && destroyElementPapyrusCommand.canExecute()) {
                this.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)destroyElementPapyrusCommand));
            }
        }
    }

    private Message getMessage() {
        Message message = null;
        CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor connectionViewAndElementDescriptor = this.request.getConnectionViewAndElementDescriptor();
        if (connectionViewAndElementDescriptor != null) {
            CreateElementRequestAdapter createElementRequestAdapter = connectionViewAndElementDescriptor.getCreateElementRequestAdapter();
            message = (Message)createElementRequestAdapter.getAdapter(Message.class);
        }
        return message;
    }

    private void retrievePreferences() {
        this.type = null;
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        if (this.request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_ASYNCH_EDGE.getSemanticHint())) {
            this.preference = store.getString(CustomDiagramGeneralPreferencePage.PREF_EXECUTION_SPECIFICATION_ASYNC_MSG);
        }
        if (this.request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_SYNCH_EDGE.getSemanticHint())) {
            this.preference = store.getString(CustomDiagramGeneralPreferencePage.PREF_EXECUTION_SPECIFICATION_SYNC_MSG);
        }
        if ("CHOICE_BEHAVIOR".equals(this.preference) || "CHOICE_BEHAVIOR_AND_REPLY".equals(this.preference)) {
            this.type = UMLDIElementTypes.BEHAVIOR_EXECUTION_SPECIFICATION_SHAPE;
        }
        if ("CHOICE_ACTION".equals(this.preference) || "CHOICE_ACTION_AND_REPLY".equals(this.preference)) {
            this.type = UMLDIElementTypes.ACTION_EXECUTION_SPECIFICATION_SHAPE;
        }
        if ("CHOICE_BEHAVIOR_AND_REPLY".equals(this.preference) || "CHOICE_ACTION_AND_REPLY".equals(this.preference)) {
            this.createReply = true;
        }
    }

    private Stream<Object> getAllCommands(Object parent) {
        Object command = null;
        command = parent instanceof ICommandProxy ? ((ICommandProxy)parent).getICommand() : parent;
        if (command instanceof CompoundCommand) {
            return ((CompoundCommand)command).getCommands().stream().flatMap(childNode -> this.getAllCommands(childNode));
        }
        if (command instanceof CompositeCommand) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((CompositeCommand)command).iterator(), 16), false).flatMap(childNode -> this.getAllCommands(childNode));
        }
        return Stream.of(command);
    }

    private <T> T getCreatedElement(org.eclipse.gef.commands.Command command, Class<T> type) {
        Object element = null;
        try {
            SemanticCreateCommand semanticCreateCommand = this.getAllCommands(command).filter(SemanticCreateCommand.class::isInstance).map(SemanticCreateCommand.class::cast).findFirst().get();
            CommandResult commandResult = semanticCreateCommand.getCommandResult();
            if (commandResult != null && commandResult.getReturnValue() instanceof CreateElementRequestAdapter) {
                element = ((CreateElementRequestAdapter)commandResult.getReturnValue()).getAdapter(type);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return (T)element;
    }
}

