/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.FollowSVGSymbolEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.NameDisplayEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.IPapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.NamedStyleProperties;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PositionEnum;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.uml2.uml.NamedElement;

public abstract class NamedElementEditPart
extends UMLNodeEditPart
implements IUMLNamedElementEditPart,
NamedStyleProperties {
    public static final int DEFAULT_TOP_MARGIN = 0;
    public static final int DEFAULT_BOTTOM_MARGIN = 0;
    public static final int DEFAULT_LEFT_MARGIN = 5;
    public static final int DEFAULT_RIGHT_MARGIN = 5;

    public NamedElementEditPart(View view) {
        super(view);
    }

    @Override
    public NamedElement getNamedElement() {
        return (NamedElement)this.getUMLElement();
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
        }
    }

    private void refreshIconNamedLabel() {
        this.getNodeNamedElementFigure().setNameLabelIcon(AppearanceHelper.showElementIcon((EModelElement)((View)this.getModel())));
    }

    @Override
    public void refresh() {
        this.refreshNamePosition();
        super.refresh();
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getNodeNamedElementFigure() != null && this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
            this.refreshLabelDisplay();
            this.refreshLabelMargin();
        }
    }

    private void refreshNamePosition() {
        if (this.getPrimaryShape() instanceof NodeNamedElementFigure) {
            ((NodeNamedElementFigure)this.getPrimaryShape()).setNamePosition(this.getNamePosition());
        }
    }

    public int getNamePosition() {
        View model = (View)this.getModel();
        StringValueStyle labelAlignment = (StringValueStyle)model.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), "textAlignment");
        int textAlignment = 0;
        if (labelAlignment != null) {
            String strLabelAlignment = labelAlignment.getStringValue();
            if (PositionEnum.LEFT.toString().equals(strLabelAlignment)) {
                textAlignment = 1;
            }
            if (PositionEnum.RIGHT.toString().equals(strLabelAlignment)) {
                textAlignment = 4;
            }
            if (PositionEnum.CENTER.toString().equals(strLabelAlignment)) {
                textAlignment = 2;
            }
        } else {
            textAlignment = this.getDefaultNamePosition();
        }
        return textAlignment;
    }

    protected int getDefaultNamePosition() {
        return 2;
    }

    private void refreshLabelMargin() {
        Object model = this.getModel();
        if (model instanceof View) {
            int leftMargin = NotationUtils.getIntValue((View)((View)model), (String)"leftMarginLabel", (int)this.getDefaultLeftNameMargin());
            int rightMargin = NotationUtils.getIntValue((View)((View)model), (String)"rightMarginLabel", (int)this.getDefaultRightNameMargin());
            int topMargin = NotationUtils.getIntValue((View)((View)model), (String)"topMarginLabel", (int)this.getDefaultTopNameMargin());
            int bottomMargin = NotationUtils.getIntValue((View)((View)model), (String)"bottomMarginLabel", (int)this.getDefaultBottomNameMargin());
            EObject semantic = this.resolveSemanticElement();
            TreeIterator contents = DiagramEditPartsUtil.getAllContents((EditPart)this, (boolean)false);
            while (contents.hasNext()) {
                IFigure figure;
                EditPart next = (EditPart)contents.next();
                if (!(next instanceof IGraphicalEditPart)) continue;
                IGraphicalEditPart gep = (IGraphicalEditPart)next;
                if (gep.resolveSemanticElement() != semantic) {
                    contents.prune();
                    continue;
                }
                IFigure iFigure = figure = gep instanceof IPapyrusEditPart ? ((IPapyrusEditPart)gep).getPrimaryShape() : gep.getFigure();
                if (!(figure instanceof IPapyrusWrappingLabel)) continue;
                IPapyrusWrappingLabel label = (IPapyrusWrappingLabel)figure;
                label.setMarginLabel(leftMargin, topMargin, rightMargin, bottomMargin);
            }
        }
    }

    protected int getDefaultBottomNameMargin() {
        return 0;
    }

    protected int getDefaultTopNameMargin() {
        return 0;
    }

    protected int getDefaultRightNameMargin() {
        return 5;
    }

    protected int getDefaultLeftNameMargin() {
        return 5;
    }

    public void activate() {
        super.activate();
    }

    protected void refreshLabelDisplay() {
        View view = this.getNotationView();
        IPapyrusNodeNamedElementFigure figure = this.getNodeNamedElementFigure();
        if (this.svgNodePlate != null) {
            if (this.svgNodePlate.hasLabelBounds()) {
                figure.getNameLabel().setTextWrap(true);
            } else {
                boolean isWrap = NotationUtils.getBooleanValue((View)view, (String)"isNameWrap", (boolean)false);
                figure.getNameLabel().setTextWrap(isWrap);
            }
        }
        figure.restoreStereotypeLabel();
        BooleanValueStyle displayNameStyle = (BooleanValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "displayName");
        BooleanValueStyle displayTags = (BooleanValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "displayTags");
        if (displayNameStyle != null && !displayNameStyle.isBooleanValue()) {
            figure.removeNameLabel();
            figure.removeTaggedLabel();
        } else {
            figure.restoreNameLabel();
            if (displayTags != null && !displayTags.isBooleanValue()) {
                figure.removeTaggedLabel();
            } else {
                figure.restoreTaggedLabel();
            }
        }
    }

    @Override
    protected void refreshLabelsFont(Font font) {
        super.refreshLabelsFont(font);
        this.getNodeNamedElementFigure().getNameLabel().setFont(font);
        if (this.getNodeNamedElementFigure().getQualifiedNameLabel() != null) {
            this.getNodeNamedElementFigure().getQualifiedNameLabel().setFont(font);
        }
        if (this.getNodeNamedElementFigure().getTaggedLabel() != null) {
            this.getNodeNamedElementFigure().getTaggedLabel().setFont(font);
        }
    }

    private IPapyrusNodeNamedElementFigure getNodeNamedElementFigure() {
        return (IPapyrusNodeNamedElementFigure)this.getPrimaryShape();
    }

    @Override
    protected void setFontColor(Color color) {
        super.setFontColor(color);
        if (this.getNodeNamedElementFigure().getQualifiedNameLabel() != null) {
            this.getNodeNamedElementFigure().getQualifiedNameLabel().setForegroundColor(color);
        }
        if (this.getNodeNamedElementFigure().getTaggedLabel() != null) {
            this.getNodeNamedElementFigure().getTaggedLabel().setForegroundColor(color);
        }
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("NAME_DISPLAY_EDITPOLICY", (EditPolicy)new NameDisplayEditPolicy());
        this.installEditPolicy("followSVGSymbolEditPolicy", (EditPolicy)new FollowSVGSymbolEditPolicy());
    }

    protected NodeFigure createNodeFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }
}

