/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.libraries.helper;

import java.sql.Timestamp;
import java.util.Iterator;
import org.eclipse.papyrus.uml.alf.libraries.helper.AlfUtil;
import org.eclipse.papyrus.uml.alf.libraries.helper.BackupState;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class BackupUtil {
    private static BackupUtil singleton;

    private BackupUtil() {
    }

    public static BackupUtil getInstance() {
        if (singleton == null) {
            singleton = new BackupUtil();
        }
        return singleton;
    }

    public Profile getBackupProfile(Model context) {
        return AlfUtil.getInstance().getAppliedProfile(context, "BackupProfile");
    }

    public Stereotype getBackupStereotype(Element context) {
        if (context != null) {
            Profile backupProfile = this.getBackupProfile(context.getModel());
            return backupProfile.getOwnedStereotype("Backup");
        }
        return null;
    }

    public Enumeration getBackupStateDefinition(Element context) {
        Type backupStateDefinition;
        Profile backupProfile;
        if (context != null && (backupProfile = this.getBackupProfile(context.getModel())) != null && (backupStateDefinition = backupProfile.getOwnedType("BackupState")) != null && backupStateDefinition instanceof Enumeration) {
            return (Enumeration)backupStateDefinition;
        }
        return null;
    }

    public Comment getBackupComment(Element element) {
        Comment backupComment = null;
        if (element != null) {
            Iterator iteratorComments = element.getOwnedComments().iterator();
            while (iteratorComments.hasNext() && backupComment == null) {
                Comment current = (Comment)iteratorComments.next();
                if (!current.getAppliedStereotypes().contains((Object)this.getBackupStereotype(element))) continue;
                backupComment = current;
            }
        }
        return backupComment;
    }

    public boolean hasBackupComment(Element element) {
        return this.getBackupComment(element) != null;
    }

    public boolean isBackup(Comment comment) {
        Stereotype backupStereotype;
        if (comment != null && (backupStereotype = this.getBackupStereotype((Element)comment)) != null) {
            return comment.getAppliedStereotypes().contains((Object)backupStereotype);
        }
        return false;
    }

    public BackupState getBackupState(Comment comment) {
        BackupState state = null;
        if (comment != null) {
            String timestamp = (String)comment.getValue(this.getBackupStereotype((Element)comment), "timestamp");
            EnumerationLiteral literal = (EnumerationLiteral)comment.getValue(this.getBackupStereotype((Element)comment), "state");
            state = new BackupState();
            try {
                state.timestamp = Timestamp.valueOf(timestamp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            state.status = this.map(literal);
        }
        return state;
    }

    private BackupState.EditionStatus map(EnumerationLiteral literal) {
        BackupState.EditionStatus status = null;
        if (literal.getLabel().equals("NONE")) {
            status = BackupState.EditionStatus.NONE;
        } else if (literal.getLabel().equals("SAVED")) {
            status = BackupState.EditionStatus.SAVED;
        } else if (literal.getLabel().equals("MERGED")) {
            status = BackupState.EditionStatus.MERGED;
        }
        return status;
    }

    private EnumerationLiteral map(BackupState.EditionStatus editionStatus, Element context) {
        Enumeration backupState;
        EnumerationLiteral status = null;
        if (context != null && (backupState = this.getBackupStateDefinition(context)) != null) {
            if (editionStatus.equals((Object)BackupState.EditionStatus.NONE)) {
                status = backupState.getOwnedLiteral("NONE");
            } else if (editionStatus.equals((Object)BackupState.EditionStatus.SAVED)) {
                status = backupState.getOwnedLiteral("SAVED");
            } else if (editionStatus.equals((Object)BackupState.EditionStatus.MERGED)) {
                status = backupState.getOwnedLiteral("MERGED");
            }
        }
        return status;
    }

    public boolean applyBackup(Comment comment, BackupState state) {
        boolean applied = this.isBackupProfileApplied((Element)comment);
        if (!applied) {
            applied = this.applyBackupProfile((Element)comment);
        }
        if (applied) {
            Stereotype backupStereotype = this.getBackupStereotype((Element)comment);
            if (!this.isBackup(comment)) {
                comment.applyStereotype(backupStereotype);
            }
            comment.setValue(backupStereotype, "timestamp", (Object)state.timestamp.toString());
            comment.setValue(backupStereotype, "state", (Object)this.map(state.status, (Element)comment));
        }
        return applied;
    }

    public boolean applyBackupProfile(Element context) {
        boolean applied = this.isBackupProfileApplied(context);
        if (!applied) {
            applied = AlfUtil.getInstance().applyProfile(context.getModel(), AlfUtil.getInstance().loadProfile(context.getModel(), "TextualRepresentationBackup"));
        }
        return applied;
    }

    public boolean isBackupProfileApplied(Element context) {
        return this.getBackupProfile(context.getModel()) != null;
    }

    public class BackupUtilConstants {
        public static final String BACKUP_PROFILE_NAME = "BackupProfile";
        public static final String BACKUP_PROFILE_LOADING_NAME = "TextualRepresentationBackup";
        public static final String BACKUP_STEREOTYPE_NAME = "Backup";
        public static final String BACKUP_BACKUP_STATE_ENUMERATION_NAME = "BackupState";
        public static final String BACKUP_TIMESTAMP_ATTR_NAME = "timestamp";
        public static final String BACKUP_STATE_ATTR_NAME = "state";
    }
}

