/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTreeRowHideShowCategoryHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;

public class TreeRowHideAllCategoriesCommandHandler
extends AbstractTreeRowHideShowCategoryHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        int maxDepth = FillingConfigurationUtils.getMaxDepthForTree(this.getTable());
        Table table = this.getTable();
        IntListValueStyle values = (IntListValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getIntListValueStyle(), "hiddenCategoriesByDepth");
        CompoundCommand cc = new CompoundCommand("Hide All categories Command");
        if (values == null) {
            values = NattablestyleFactory.eINSTANCE.createIntListValueStyle();
            cc.append(AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)table, (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), Collections.singleton(values)));
            cc.append(SetCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)values, (Object)NattablestylePackage.eINSTANCE.getNamedStyle_Name(), (Object)"hiddenCategoriesByDepth"));
        }
        ArrayList<Integer> toHide = new ArrayList<Integer>();
        int start = 0;
        if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), 0)) {
            start = 1;
        }
        int i = start;
        while (i <= maxDepth) {
            toHide.add(i);
            ++i;
        }
        cc.append(SetCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)values, (Object)NattablestylePackage.eINSTANCE.getIntListValueStyle_IntListValue(), toHide));
        this.getTableEditingDomain().getCommandStack().execute((Command)cc);
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (this.isEnabled() && this.allCategoriesAreCurrentlyHidden()) {
            this.setBaseEnabled(false);
        }
    }
}

