/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.lang.reflect.Array;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> T[] add(T[] array, T element) {
        int length = array.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length + 1);
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = element;
        return newArray;
    }

    public static <T> T[] remove(T[] array, T element) {
        int length = array.length;
        int i = 0;
        while (i < array.length) {
            T t = array[i];
            if (ObjectUtil.equals(t, element)) {
                int next;
                Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length - 1);
                if (i != 0) {
                    System.arraycopy(array, 0, newArray, 0, i);
                }
                if ((next = i + 1) <= length) {
                    System.arraycopy(array, next, newArray, i, length - next);
                }
                return newArray;
            }
            ++i;
        }
        return array;
    }

    public static String toString(Object[] array) {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        int i = 0;
        while (i < array.length) {
            Object element = array[i];
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(element);
            ++i;
        }
        builder.append('}');
        return builder.toString();
    }
}

