/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.PrimeFinder;

public final class SetLong
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BIG_CAPACITY = PrimeFinder.findPrevPrime(0x7FFFFFF8) - 1;
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private long[] keys;

    public SetLong() {
        this(10);
    }

    public SetLong(int initialCapacity) {
        this.init(initialCapacity);
    }

    public boolean add(long key) {
        if (this.size == this.limit) {
            this.resize(this.capacity <= BIG_CAPACITY >> 1 ? this.capacity << 1 : (this.capacity < BIG_CAPACITY ? BIG_CAPACITY : this.capacity + 1));
        }
        int hash = this.hash(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return false;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        ++this.size;
        return true;
    }

    public boolean remove(long key) {
        int hash = this.hash(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                this.used[hash] = false;
                --this.size;
                hash = (hash + this.step) % this.capacity;
                while (this.used[hash]) {
                    key = this.keys[hash];
                    this.used[hash] = false;
                    int newHash = this.hash(key) % this.capacity;
                    while (this.used[newHash]) {
                        newHash = (newHash + this.step) % this.capacity;
                    }
                    this.used[newHash] = true;
                    this.keys[newHash] = key;
                    hash = (hash + this.step) % this.capacity;
                }
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public boolean contains(long key) {
        int hash = this.hash(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    public IteratorLong iterator() {
        return new IteratorLong(){
            int n = 0;
            int i = -1;

            public boolean hasNext() {
                return this.n < SetLong.this.size;
            }

            public long next() throws NoSuchElementException {
                while (++this.i < SetLong.this.used.length) {
                    if (!SetLong.this.used[this.i]) continue;
                    ++this.n;
                    return SetLong.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public long[] toArray() {
        long[] array = new long[this.size];
        int j = 0;
        int i = 0;
        while (i < this.used.length) {
            if (this.used[i]) {
                array[j++] = this.keys[i];
            }
            ++i;
        }
        return array;
    }

    private int hash(long key) {
        return (int)(key & Integer.MAX_VALUE);
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new long[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        long[] oldKeys = this.keys;
        this.keys = null;
        this.capacity = 0;
        this.init(newCapacity);
        int i = 0;
        while (i < oldUsed.length) {
            if (oldUsed[i]) {
                long key = oldKeys[i];
                int hash = this.hash(key) % this.capacity;
                while (this.used[hash]) {
                    hash = (hash + this.step) % this.capacity;
                }
                this.used[hash] = true;
                this.keys[hash] = key;
            }
            ++i;
        }
        this.size = oldSize;
    }
}

