/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.internal.discovery.Messages;
import org.eclipse.m2e.internal.discovery.strategy.M2ERemoteBundleDiscoveryStrategy;
import org.eclipse.m2e.internal.discovery.wizards.MavenCatalogConfiguration;
import org.eclipse.m2e.internal.discovery.wizards.MavenDiscoveryWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDiscovery {
    private static final Logger log = LoggerFactory.getLogger(MavenDiscovery.class);
    public static final Tag NO_RESTART_TAG = new Tag("norestart", "norestart");
    public static final Tag APPLICABLE_TAG = new Tag("applicable", Messages.MavenDiscovery_Wizard_Applicable_Tag);
    private static final Tag EXTRAS_TAG = new Tag("extras", Messages.MavenDiscovery_Wizard_ExtrasTag);
    private static final Tag LIFECYCLES_TAG = new Tag("lifecycles", Messages.MavenDiscovery_Wizard_LifecyclesTag);
    private static final Tag MAVEN_TAG = new Tag("maven", Messages.MavenDiscovery_Wizard_MavenTag);
    private static final String DEFAULT_BASEURL = "http://download.eclipse.org/technology/m2e/discovery/";
    private static final String DEFAULT_FILENAME = "directory-1.10.xml";
    public static final String DEFAULT_URL = "http://download.eclipse.org/technology/m2e/discovery/directory-1.10.xml";
    private static final String CONFIGURED_URL = System.getProperty("m2e.discovery.url");
    private static final String BASEURL = System.getProperty("m2e.discovery.baseurl", "http://download.eclipse.org/technology/m2e/discovery/");
    public static final String PATH = CONFIGURED_URL != null ? CONFIGURED_URL : String.valueOf(BASEURL) + "directory-1.10.xml";
    public static final String LIFECYCLE_PATH = "lifecycle/";
    public static final String LIFECYCLE_EXT = ".xml";
    public static final String PLUGINXML_EXT = ".pluginxml";

    public static void launchWizard(Shell shell) {
        MavenDiscovery.launchWizard(shell, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static void launchWizard(final Collection<String> packagingTypes, final Collection<MojoExecutionKey> mojos, final Collection<String> lifecycleIds, final Collection<String> configuratorIds) {
        final Display display = Workbench.getInstance().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MavenDiscovery.launchWizard(display.getActiveShell(), packagingTypes, mojos, lifecycleIds, configuratorIds);
            }
        });
    }

    public static void launchWizard(Shell shell, Collection<String> packagingTypes, Collection<MojoExecutionKey> mojos, Collection<String> lifecycleIds, Collection<String> configuratorIds) {
        Catalog catalog = MavenDiscovery.getCatalog();
        ArrayList<Tag> tags = new ArrayList<Tag>(3);
        if (!(packagingTypes.isEmpty() && mojos.isEmpty() && configuratorIds.isEmpty() && lifecycleIds.isEmpty())) {
            tags.add(APPLICABLE_TAG);
        }
        tags.add(EXTRAS_TAG);
        tags.add(LIFECYCLES_TAG);
        tags.add(MAVEN_TAG);
        catalog.setTags(tags);
        MavenCatalogConfiguration configuration = new MavenCatalogConfiguration();
        configuration.setShowTagFilter(true);
        if (!(packagingTypes.isEmpty() && mojos.isEmpty() && configuratorIds.isEmpty() && lifecycleIds.isEmpty())) {
            tags = new ArrayList(1);
            tags.add(APPLICABLE_TAG);
            configuration.setSelectedTags(tags);
        } else {
            configuration.setSelectedTags(tags);
        }
        configuration.setShowInstalledFilter(false);
        configuration.setSelectedPackagingTypes(packagingTypes);
        configuration.setSelectedMojos(mojos);
        configuration.setSelectedLifecycleIds(lifecycleIds);
        configuration.setSelectedConfigurators(configuratorIds);
        MavenDiscoveryWizard wizard = new MavenDiscoveryWizard(catalog, configuration);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
    }

    public static Catalog getCatalog() {
        Catalog catalog = new Catalog();
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        M2ERemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new M2ERemoteBundleDiscoveryStrategy();
        remoteDiscoveryStrategy.setDirectoryUrl(PATH);
        catalog.getDiscoveryStrategies().add(remoteDiscoveryStrategy);
        return catalog;
    }

    public static LifecycleMappingMetadataSource getLifecycleMappingMetadataSource(CatalogItem ci) {
        block9: {
            LifecycleMappingMetadataSource lifecycleMappingMetadataSource;
            URL url;
            block8: {
                url = null;
                url = MavenDiscovery.getLifecycleMappingMetadataSourceURL(ci);
                if (url != null) break block8;
                return null;
            }
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection) {
                ((JarURLConnection)conn).setDefaultUseCaches(false);
            }
            InputStream is = conn.getInputStream();
            try {
                lifecycleMappingMetadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    IOUtil.close((InputStream)is);
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    log.info("No lifecyle mapping found at " + url);
                    break block9;
                }
                catch (Exception e) {
                    log.warn(NLS.bind((String)Messages.MavenCatalogViewer_Error_loading_lifecycle, (Object)ci.getId()), (Throwable)e);
                }
            }
            IOUtil.close((InputStream)is);
            return lifecycleMappingMetadataSource;
        }
        return null;
    }

    public static boolean requireRestart(Iterable<CatalogItem> catalogItems) {
        for (CatalogItem item : catalogItems) {
            if (item.hasTag(NO_RESTART_TAG)) continue;
            return true;
        }
        return false;
    }

    public static void getProvidedProjectConfigurators(CatalogItem ci, List<String> projectConfigurators, List<String> mappingStrategies) {
        try {
            URL url = ci.getSource().getResource(LIFECYCLE_PATH + ci.getId() + PLUGINXML_EXT);
            if (url != null) {
                InputStream is = url.openStream();
                MavenDiscovery.parsePluginXml(is, projectConfigurators, mappingStrategies);
            }
        }
        catch (FileNotFoundException e) {
            log.warn("CatalogItem {} does not contain lifecycle mapping metadata", (Object)ci.getId());
        }
        catch (Exception e) {
            log.warn(NLS.bind((String)Messages.MavenCatalogViewer_Error_loading_lifecycle, (Object)ci.getId()), (Throwable)e);
        }
    }

    public static void parsePluginXml(InputStream is, List<String> configurators, List<String> mappingStrategies) throws XmlPullParserException, IOException {
        Xpp3Dom[] extensions;
        Xpp3Dom plugin = Xpp3DomBuilder.build((InputStream)is, (String)"UTF-8");
        Xpp3Dom[] xpp3DomArray = extensions = plugin.getChildren("extension");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            int n3;
            int n4;
            Xpp3Dom[] xpp3DomArray2;
            Xpp3Dom extension = xpp3DomArray[n2];
            String extensionPoint = extension.getAttribute("point");
            if ("org.eclipse.m2e.core.projectConfigurators".equals(extensionPoint)) {
                Xpp3Dom[] configuratorsDom;
                xpp3DomArray2 = configuratorsDom = extension.getChildren("configurator");
                n4 = configuratorsDom.length;
                n3 = 0;
                while (n3 < n4) {
                    Xpp3Dom configurator = xpp3DomArray2[n3];
                    id = configurator.getAttribute("id");
                    if (id != null) {
                        configurators.add(id);
                    }
                    ++n3;
                }
            } else if ("org.eclipse.m2e.core.lifecycleMappings".equals(extensionPoint)) {
                Xpp3Dom[] lifecycleMappingsDom;
                xpp3DomArray2 = lifecycleMappingsDom = extension.getChildren("lifecycleMapping");
                n4 = lifecycleMappingsDom.length;
                n3 = 0;
                while (n3 < n4) {
                    Xpp3Dom lifecycleMapping = xpp3DomArray2[n3];
                    id = lifecycleMapping.getAttribute("id");
                    if (id != null) {
                        mappingStrategies.add(id);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public static URL getLifecycleMappingMetadataSourceURL(CatalogItem ci) {
        return ci.getSource().getResource(LIFECYCLE_PATH + ci.getId() + LIFECYCLE_EXT);
    }
}

