/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;

public class ParentGatherer {
    final IMavenProjectFacade projectFacade;

    public ParentGatherer(IMavenProjectFacade facade) {
        this.projectFacade = facade;
    }

    public List<ParentHierarchyEntry> getParentHierarchy(IProgressMonitor monitor) throws CoreException {
        final ArrayList<ParentHierarchyEntry> hierarchy = new ArrayList<ParentHierarchyEntry>();
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        final IMaven maven = MavenPlugin.getMaven();
        final MavenProject mavenProject = this.projectFacade.getMavenProject(monitor);
        hierarchy.add(new ParentHierarchyEntry(mavenProject, this.projectFacade));
        projectManager.execute(this.projectFacade, (ICallable)new ICallable<Void>(){

            public Void call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                MavenProject project = mavenProject;
                while (project.getModel().getParent() != null) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    IFile resource = M2EUtils.getPomFile((MavenProject)(project = maven.resolveParentProject(project, monitor)));
                    IMavenProjectFacade facade = resource != null ? MavenPlugin.getMavenProjectRegistry().getProject(resource.getProject()) : null;
                    hierarchy.add(new ParentHierarchyEntry(project, facade));
                }
                return null;
            }
        }, monitor);
        return hierarchy;
    }
}

