/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.properties.extension.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.properties.extension.internal.ClassPropertySheetPageDescriptor;
import org.eclipse.jwt.we.editors.properties.extension.internal.PropertySheetPageDescriptor;
import org.eclipse.jwt.we.editors.properties.singlePage.ModelPropertySheetPage;
import org.eclipse.jwt.we.editors.properties.tabbedPage.TabbedModelPropertySheetPage;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class PropertySheetPageExtensionPoint {
    public static final String EXTENSION_POINT = String.valueOf(Plugin.getId()) + ".propertySheet";
    private static final String CLASS = "class";
    private static final String PROPERTY_TABS_EXTENSION_POINT = "org.eclipse.ui.views.properties.tabbed.propertyTabs";
    private static Logger log = Logger.getLogger(PropertySheetPageExtensionPoint.class);
    private static PropertySheetPageDescriptor propertySheetPageDescriptor = null;
    private static boolean initialized = false;

    private static synchronized void init() {
        if (!initialized) {
            try {
                PropertySheetPageExtensionPoint.processExtensionPoint();
            }
            catch (WorkbenchException workbenchException) {
                log.severe("Error processing extension point for custom RootAdapterFactory");
            }
            if (propertySheetPageDescriptor == null) {
                propertySheetPageDescriptor = PropertySheetPageExtensionPoint.createDefaultPropertySheetPageDescriptor();
            }
            initialized = true;
        }
    }

    public static IPropertySheetPage createPropertySheetPage(WEEditor weEditor) {
        PropertySheetPageExtensionPoint.init();
        if (propertySheetPageDescriptor != null) {
            return propertySheetPageDescriptor.createPropertySheetPage(weEditor);
        }
        return null;
    }

    private static void processExtensionPoint() throws WorkbenchException {
        log.debug("Processing extension point " + EXTENSION_POINT);
        IConfigurationElement[] confElements = ExtensionsHelper.findConfigurationElements(EXTENSION_POINT);
        if (confElements != null && confElements.length == 1) {
            IConfigurationElement confElement = confElements[0];
            try {
                String pageClassName = confElement.getAttribute(CLASS);
                String extensionName = confElement.getDeclaringExtension().getNamespaceIdentifier();
                Class pageClass = Platform.getBundle((String)extensionName).loadClass(pageClassName);
                propertySheetPageDescriptor = new ClassPropertySheetPageDescriptor(pageClass);
            }
            catch (Exception e) {
                log.severe("Error loading custom property sheet", e);
            }
            if (propertySheetPageDescriptor != null) {
                log.info("JWT Property Sheet extension - found custom property sheet page at " + EXTENSION_POINT + ": " + propertySheetPageDescriptor);
            }
        } else {
            log.info("JWT Extension at " + EXTENSION_POINT + " - found no or more than one custom propertySheetPageDescriptor");
        }
    }

    public static final PropertySheetPageDescriptor createDefaultPropertySheetPageDescriptor() {
        IConfigurationElement[] allElements = ExtensionsHelper.findConfigurationElements(PROPERTY_TABS_EXTENSION_POINT);
        ArrayList<IConfigurationElement> confElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = allElements;
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement point = iConfigurationElementArray[n2];
            String contributorId = point.getAttribute("contributorId");
            if (contributorId != null && contributorId.equals("org.eclipse.jwt.we.editors.WEEditor")) {
                confElements.add(point);
            }
            ++n2;
        }
        if (confElements.size() == 1) {
            log.info("JWT Extension - no additional property tabs, using standard propertyview");
            return new PropertySheetPageDescriptor(){

                public IPropertySheetPage createPropertySheetPage(WEEditor weEditor) {
                    return new ModelPropertySheetPage(weEditor.getAdapterFactory());
                }
            };
        }
        log.info("JWT Extension - found additional property tabs, using multitab propertyview");
        for (IConfigurationElement point : confElements) {
            log.info("JWT Extension - found PROPERTYTAB at org.eclipse.ui.views.properties.tabbed.propertyTabs: " + point.getChildren()[0].getAttribute("label"));
        }
        return new PropertySheetPageDescriptor(){

            public IPropertySheetPage createPropertySheetPage(WEEditor weEditor) {
                return new TabbedModelPropertySheetPage(weEditor);
            }
        };
    }
}

