/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class RenameBranchOperation
implements IEGitOperation {
    private final Repository repository;
    private final Ref branch;
    private final String newName;

    public RenameBranchOperation(Repository repository, Ref branch, String newName) {
        this.repository = repository;
        this.branch = branch;
        this.newName = newName;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                String taskName = NLS.bind((String)CoreText.RenameBranchOperation_TaskName, (Object)RenameBranchOperation.this.branch.getName(), (Object)RenameBranchOperation.this.newName);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor);
                progress.setTaskName(taskName);
                try {
                    Throwable throwable = null;
                    Object var5_8 = null;
                    try (Git git = new Git(RenameBranchOperation.this.repository);){
                        git.branchRename().setOldName(RenameBranchOperation.this.branch.getName()).setNewName(RenameBranchOperation.this.newName).call();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (JGitInternalException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                catch (GitAPIException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

