/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.ui.launch;

import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoProjectTester;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.ui.InputComponent;
import org.eclipse.corrosion.ui.OptionalDefaultInputComponent;
import org.eclipse.corrosion.ui.cargo.OptionSelector;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractCargoLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private InputComponent projectInput;
    private OptionalDefaultInputComponent workingDirectoryInput;
    private InputComponent optionsInput;
    private InputComponent argsInput;
    private IProject project;
    private static CargoProjectTester tester = new CargoProjectTester();

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("PROJECT", this.projectInput.getValue());
        configuration.setAttribute("ARGUMENTS", this.argsInput.getValue());
        configuration.setAttribute("OPTIONS", this.optionsInput.getValue());
        configuration.setAttribute("WORKING_DIRECTORY", this.workingDirectoryInput.getValue());
        this.setDirty(false);
    }

    public void createControl(Composite parent) {
        Group container = new Group(parent, 2048);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectInput = new InputComponent((Composite)container, Messages.LaunchUI_project, result -> {
            this.setDirty(true);
            this.setProject(this.projectInput.getValue());
            this.updateLaunchConfigurationDialog();
        });
        this.projectInput.createComponent();
        this.projectInput.createProjectSelection();
        this.createExtraControlsGroup((Composite)container);
        this.workingDirectoryInput = new OptionalDefaultInputComponent((Composite)container, Messages.LaunchUI_workingDirectory, result -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }, () -> this.getDefaultWorkingDirectoryPath());
        this.workingDirectoryInput.createComponent();
        this.workingDirectoryInput.createContainerSelection(() -> this.project);
    }

    protected abstract String getCommandGroupText();

    protected abstract String getCargoSubcommand();

    protected Group createExtraControlsGroup(Composite container) {
        Group commandGroup = new Group(container, 0);
        commandGroup.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        commandGroup.setLayout((Layout)new GridLayout(4, false));
        commandGroup.setText(this.getCommandGroupText());
        this.optionsInput = new InputComponent((Composite)commandGroup, Messages.LaunchUI_options, e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.optionsInput.createComponent();
        this.optionsInput.makeSpaceForButton();
        Button optionButton = new Button((Composite)commandGroup, 0);
        optionButton.setText(Messages.LaunchUI_optionsColon);
        optionButton.setLayoutData((Object)new GridData(4, 128, false, false));
        optionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            OptionSelector dialog = new OptionSelector(optionButton.getShell(), CargoTools.getOptions(this.getCargoSubcommand()).stream().filter(o -> !o.getFlag().equals("--manifest-path")).collect(Collectors.toList()));
            dialog.open();
            String result = dialog.returnOptionSelection();
            if (result != null) {
                this.optionsInput.setValue(String.valueOf(this.optionsInput.getValue()) + " " + result);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.optionsInput.createVariableSelection();
        this.argsInput = new InputComponent((Composite)commandGroup, Messages.LaunchUI_arguments, e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.argsInput.createComponent();
        this.argsInput.createVariableSelection();
        return commandGroup;
    }

    private String getDefaultWorkingDirectoryPath() {
        if (this.project == null) {
            return "";
        }
        return this.project.getName();
    }

    private void setProject(String projectName) {
        this.project = !this.projectInput.getValue().isEmpty() ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
        if (this.workingDirectoryInput.getSelection()) {
            this.workingDirectoryInput.setValue(this.getDefaultWorkingDirectoryPath());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("PROJECT", "");
        configuration.setAttribute("ARGUMENTS", "");
        configuration.setAttribute("OPTIONS", "");
        configuration.setAttribute("WORKING_DIRECTORY", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projectInput.setValue(configuration.getAttribute("PROJECT", ""));
        }
        catch (CoreException ce) {
            this.projectInput.setValue("");
        }
        try {
            this.optionsInput.setValue(configuration.getAttribute("OPTIONS", ""));
        }
        catch (CoreException ce) {
            this.optionsInput.setValue("");
        }
        try {
            this.argsInput.setValue(configuration.getAttribute("ARGUMENTS", ""));
        }
        catch (CoreException ce) {
            this.argsInput.setValue("");
        }
        try {
            this.workingDirectoryInput.setValue(configuration.getAttribute("WORKING_DIRECTORY", ""));
        }
        catch (CoreException ce) {
            this.workingDirectoryInput.setValue("");
        }
        this.workingDirectoryInput.updateSelection(this.workingDirectoryInput.getValue().equals(this.getDefaultWorkingDirectoryPath()));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.canSave();
    }

    public boolean canSave() {
        if (this.project == null || !this.project.exists() || !tester.test(this.project, "isCargoProject", null, null)) {
            this.setErrorMessage(Messages.LaunchUI_invalidCargoProjectName);
            return false;
        }
        if (this.workingDirectoryInput.getValue().isEmpty()) {
            this.setErrorMessage(Messages.LaunchUI_invalidWorkingDirectory);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getName() {
        return Messages.LaunchUI_main;
    }
}

