/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.Arrays;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.cdt.ui.newui.INewCfgDialog;
import org.eclipse.cdt.ui.newui.NewConfigurationDialog;
import org.eclipse.cdt.ui.newui.RenameConfigurationDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ManageConfigDialog
extends Dialog {
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.newCfgDialog";
    public static final String ELEMENT_NAME = "dialog";
    public static final String CLASS_NAME = "class";
    public static final String TITLE_NAME = "title";
    public static final String ID_NAME = "mbs_id";
    private ICProjectDescription des;
    private IProject prj;
    private String title;
    private String mbs_id;
    protected Table table;
    protected Button actBtn;
    protected Button newBtn;
    protected Button renBtn;
    protected Button delBtn;

    ManageConfigDialog(Shell parentShell, String _title, IProject _prj) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = _title;
        this.prj = _prj;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(4, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.table = new Table(composite, 68356);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.updateButtons();
            }
        });
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(Messages.ManageConfigDialog_1);
        col.setWidth(100);
        col = new TableColumn(this.table, 0);
        col.setText(Messages.ManageConfigDialog_2);
        col.setWidth(120);
        col = new TableColumn(this.table, 0);
        col.setText(Messages.ManageConfigDialog_3);
        col.setWidth(80);
        this.actBtn = new Button(composite, 8);
        this.actBtn.setText(Messages.ManageConfigDialog_4);
        this.actBtn.setLayoutData((Object)new GridData(768));
        this.actBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tis = ManageConfigDialog.this.table.getSelection();
                if (tis == null || tis.length != 1) {
                    return;
                }
                ICConfigurationDescription cfgd = (ICConfigurationDescription)tis[0].getData();
                ManageConfigDialog.this.des.setActiveConfiguration(cfgd);
                ManageConfigDialog.this.updateData();
            }
        });
        this.newBtn = new Button(composite, 8);
        this.newBtn.setText(Messages.BuildPropertyCommon_label_new);
        this.newBtn.setLayoutData((Object)new GridData(768));
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleNewPressed();
            }
        });
        this.delBtn = new Button(composite, 8);
        this.delBtn.setText(Messages.BuildPropertyCommon_label_remove);
        this.delBtn.setLayoutData((Object)new GridData(768));
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRemovePressed();
            }
        });
        this.renBtn = new Button(composite, 8);
        this.renBtn.setText(Messages.ManageConfig_label_rename);
        this.renBtn.setLayoutData((Object)new GridData(768));
        this.renBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRenamePressed();
            }
        });
        this.des = CDTPropertyManager.getProjectDescription((Widget)composite, this.prj);
        this.updateData();
        return composite;
    }

    protected void handleNewPressed() {
        INewCfgDialog dialog = this.handleSpecificMBS(this.mbs_id);
        if (dialog == null) {
            dialog = new NewConfigurationDialog(this.getShell());
            dialog.setTitle(Messages.ManageConfig_label_new_config_dialog);
        }
        dialog.setProject(this.des);
        if (dialog.open() == 0) {
            this.updateData();
        }
    }

    protected INewCfgDialog handleSpecificMBS(String id) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int k = 0;
            while (k < elements.length) {
                if (elements[k].getName().equals(ELEMENT_NAME) && id.equals(elements[k].getAttribute(ID_NAME))) {
                    INewCfgDialog dialog = null;
                    try {
                        dialog = (INewCfgDialog)elements[k].createExecutableExtension(CLASS_NAME);
                        dialog.setTitle(elements[k].getAttribute(TITLE_NAME));
                        dialog.setShell(this.getShell());
                        return dialog;
                    }
                    catch (CoreException e) {
                        System.out.println("Cannot create dialog: " + e.getLocalizedMessage());
                        return null;
                    }
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    protected void handleRenamePressed() {
        int sel = this.table.getSelectionIndex();
        if (sel != -1) {
            ICConfigurationDescription cfgd = (ICConfigurationDescription)this.table.getItem(sel).getData();
            RenameConfigurationDialog dialog = new RenameConfigurationDialog(this.getShell(), cfgd, this.des.getConfigurations(), Messages.ManageConfig_label_rename_config_dialog);
            if (dialog.open() == 0) {
                cfgd.setName(dialog.getNewName());
                cfgd.setDescription(dialog.getNewDescription());
                this.updateData();
            }
        }
    }

    protected void handleRemovePressed() {
        TableItem[] tis = this.table.getSelection();
        if (tis == null || tis.length < 1) {
            return;
        }
        Object[] names = new String[tis.length];
        int i = 0;
        while (i < tis.length) {
            names[i] = tis[i].getText(0);
            ++i;
        }
        Shell shell = CUIPlugin.getActiveWorkbenchShell();
        boolean shouldDelete = MessageDialog.openQuestion((Shell)shell, (String)Messages.ManageConfig_deletedialog_title, (String)NLS.bind((String)Messages.ManageConfig_deletedialog_message, (Object[])names));
        if (shouldDelete) {
            boolean wasActive = false;
            int j = 0;
            while (j < tis.length) {
                ICConfigurationDescription cfgd = (ICConfigurationDescription)tis[j].getData();
                if (cfgd.isActive()) {
                    wasActive = true;
                }
                this.des.removeConfiguration(cfgd);
                ++j;
            }
            ICConfigurationDescription[] cfgds = this.des.getConfigurations();
            if (wasActive && cfgds.length > 0) {
                cfgds[0].setActive();
                this.des.setActiveConfiguration(cfgds[0]);
            }
            this.updateData();
        }
    }

    private void updateButtons() {
        int sel = this.table.getSelectionCount();
        this.delBtn.setEnabled(sel > 0 & sel < this.table.getItemCount());
        this.renBtn.setEnabled(sel == 1);
        if (sel == 1) {
            ICConfigurationDescription c = (ICConfigurationDescription)this.table.getSelection()[0].getData();
            this.actBtn.setEnabled(c != null && !c.isActive());
        } else {
            this.actBtn.setEnabled(false);
        }
    }

    private void updateData() {
        this.table.removeAll();
        ICConfigurationDescription[] cfgds = this.des.getConfigurations();
        this.mbs_id = cfgds[0].getBuildSystemId();
        Arrays.sort(cfgds, CDTListComparator.getInstance());
        int i = 0;
        while (i < cfgds.length) {
            TableItem t = new TableItem(this.table, 0);
            t.setText(0, cfgds[i].getName());
            String description = cfgds[i].getDescription();
            if (description == null) {
                description = "";
            }
            t.setText(1, description);
            t.setText(2, cfgds[i].isActive() ? Messages.ManageConfigDialog_5 : "");
            t.setData((Object)cfgds[i]);
            ++i;
        }
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
        }
        this.table.setFocus();
        this.updateButtons();
    }

    ICProjectDescription getProjectDescription() {
        return this.des;
    }
}

