/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.mi.service.command.IEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.events.MIErrorEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.service.DsfSession;

public class MIAsyncErrorProcessor
implements IEventProcessor {
    private final ICommandControlService fCommandControl;
    private Map<IRunControl.IExecutionDMContext, Integer> fRunCommands = new HashMap<IRunControl.IExecutionDMContext, Integer>();

    public MIAsyncErrorProcessor(ICommandControlService commandControl) {
        this.fCommandControl = commandControl;
        this.fCommandControl.addCommandListener((ICommandListener)this);
        this.fCommandControl.addEventListener((IEventListener)this);
    }

    public void eventReceived(Object output) {
        MIResultRecord rr = ((MIOutput)output).getMIResultRecord();
        if (rr != null && "error".equals(rr.getResultClass())) {
            this.handleAsyncError((MIOutput)output);
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        MIResultRecord rr;
        IDMContext ctx;
        if (token.getCommand() instanceof MICommand && result instanceof MIInfo && ((MIInfo)result).isRunning() && (ctx = ((MICommand)token.getCommand()).getContext()) instanceof IRunControl.IExecutionDMContext && (rr = ((MIInfo)result).getMIOutput().getMIResultRecord()) != null) {
            this.fRunCommands.put((IRunControl.IExecutionDMContext)ctx, rr.getToken());
        }
    }

    @Override
    public void dispose() {
        this.fCommandControl.removeCommandListener((ICommandListener)this);
        this.fCommandControl.removeEventListener((IEventListener)this);
        this.fRunCommands.clear();
    }

    protected ICommandControlService getCommandControl() {
        return this.fCommandControl;
    }

    protected void handleAsyncError(MIOutput output) {
        int token = output.getMIResultRecord().getToken();
        for (Map.Entry<IRunControl.IExecutionDMContext, Integer> entry : this.fRunCommands.entrySet()) {
            if (entry.getValue() != token || !DsfSession.isSessionActive((String)entry.getKey().getSessionId())) continue;
            this.fireStoppedEvent(output, entry.getKey());
        }
    }

    protected void fireStoppedEvent(MIOutput output, IRunControl.IExecutionDMContext ctx) {
        DsfSession session = DsfSession.getSession((String)ctx.getSessionId());
        int token = output.getMIResultRecord().getToken();
        session.dispatchEvent((Object)MIErrorEvent.parse(ctx, token, output.getMIResultRecord().getMIResults(), output.getMIOOBRecords()), null);
    }
}

