/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.tracepointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.AbstractTracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.MessagesForTracepointActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class EvaluateAction
extends AbstractTracepointAction {
    private static final String EVALUATE_ACTION_ID = "org.eclipse.cdt.dsf.gdb.tracepointactions.EvaluateAction";
    private String fEvalString = "";

    public String getDefaultName() {
        return MessagesForTracepointActions.TracepointActions_Untitled_Evaluate;
    }

    public String getEvalString() {
        return this.fEvalString;
    }

    public void setEvalString(String str) {
        this.fEvalString = str;
    }

    public String getIdentifier() {
        return EVALUATE_ACTION_ID;
    }

    public String getMemento() {
        String collectData = "";
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("evalData");
            rootElement.setAttribute("evalString", this.fEvalString);
            doc.appendChild(rootElement);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            collectData = s.toString("UTF8");
        }
        catch (Exception e) {
            GdbPlugin.log(e);
        }
        return collectData;
    }

    public String getSummary() {
        return String.format("teval %s", this.fEvalString);
    }

    public String getTypeName() {
        return MessagesForTracepointActions.TracepointActions_Evaluate_Name;
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            this.fEvalString = root.getAttribute("evalString");
            if (this.fEvalString == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            GdbPlugin.log(e);
        }
    }

    public String toString() {
        return this.getSummary();
    }
}

