/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.CompositeValue;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUnary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalMemberAccess
extends CPPDependentEvaluation {
    private final IType fOwnerType;
    private final IBinding fMember;
    private final IASTExpression.ValueCategory fOwnerValueCategory;
    private final boolean fIsPointerDeref;
    private ICPPEvaluation fOwnerEval;
    private IType fType;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsValueDependent;
    private boolean fCheckedIsValueDependent;

    public EvalMemberAccess(IType ownerType, IASTExpression.ValueCategory ownerValueCat, IBinding member, boolean isPointerDeref, IASTNode pointOfDefinition) {
        this(ownerType, ownerValueCat, member, isPointerDeref, EvalMemberAccess.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalMemberAccess(IType ownerType, IASTExpression.ValueCategory ownerValueCat, IBinding member, boolean isPointerDeref, IBinding templateDefinition) {
        this(ownerType, ownerValueCat, member, null, isPointerDeref, templateDefinition);
    }

    public EvalMemberAccess(IType ownerType, IASTExpression.ValueCategory ownerValueCat, IBinding member, ICPPEvaluation ownerEval, boolean isDeref, IASTNode pointOfDefinition) {
        this(ownerType, ownerValueCat, member, ownerEval, isDeref, EvalMemberAccess.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalMemberAccess(IType ownerType, IASTExpression.ValueCategory ownerValueCat, IBinding member, ICPPEvaluation ownerEval, boolean isDeref, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOwnerType = ownerType;
        this.fOwnerValueCategory = ownerValueCat;
        this.fMember = member;
        this.fIsPointerDeref = isDeref;
        this.fOwnerEval = ownerEval;
    }

    public IType getOwnerType() {
        return this.fOwnerType;
    }

    public IASTExpression.ValueCategory getOwnerValueCategory() {
        return this.fOwnerValueCategory;
    }

    public ICPPEvaluation getOwnerEval() {
        return this.fOwnerEval;
    }

    public IBinding getMember() {
        return this.fMember;
    }

    public boolean isPointerDeref() {
        return this.fIsPointerDeref;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = this.computeIsTypeDependent();
        }
        return this.fIsTypeDependent;
    }

    private boolean computeIsTypeDependent() {
        IType t;
        if (this.fMember instanceof ICPPUnknownBinding) {
            return true;
        }
        if (this.fMember instanceof IEnumerator) {
            t = ((IEnumerator)this.fMember).getType();
        } else if (this.fMember instanceof IVariable) {
            t = ((IVariable)this.fMember).getType();
        } else if (this.fMember instanceof IFunction) {
            t = ((IFunction)this.fMember).getType();
        } else {
            return false;
        }
        return CPPTemplates.isDependentType(t);
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedIsValueDependent) {
            this.fCheckedIsValueDependent = true;
            this.fIsValueDependent = this.computeIsValueDependent();
        }
        return this.fIsValueDependent;
    }

    private boolean computeIsValueDependent() {
        if (this.fMember instanceof ICPPUnknownBinding) {
            return true;
        }
        if (this.fMember instanceof IEnumerator) {
            return IntegralValue.isDependentValue(((IEnumerator)this.fMember).getValue());
        }
        if (this.fMember instanceof IVariable) {
            return IntegralValue.isDependentValue(((IVariable)this.fMember).getInitialValue());
        }
        if (this.fMember instanceof IFunction) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isConstantExpression() {
        if (this.fOwnerEval != null) {
            return this.fOwnerEval.isConstantExpression();
        }
        return false;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalMemberAccess)) {
            return false;
        }
        EvalMemberAccess o = (EvalMemberAccess)other;
        return this.fOwnerType.isSameType(o.fOwnerType) && this.fMember == o.fMember && this.fOwnerValueCategory == o.fOwnerValueCategory && this.fIsPointerDeref == o.fIsPointerDeref;
    }

    public static IType getFieldOwnerType(IType fieldOwnerExpressionType, boolean isDeref, Collection<ICPPFunction> functionBindings, boolean returnDependent) {
        IType prValue;
        IType type = fieldOwnerExpressionType;
        if (!isDeref) {
            return type;
        }
        int j = 0;
        while (j < 20) {
            ICPPEvaluation[] args;
            ICPPFunction op;
            IScope scope;
            IType classType = SemanticUtil.getUltimateTypeUptoPointers(type);
            if (!(classType instanceof ICPPClassType) || (scope = ((ICPPClassType)classType).getCompositeScope()) == null || scope instanceof ICPPInternalUnknownScope || (op = CPPSemantics.findOverloadedOperator(null, args = new ICPPEvaluation[]{new EvalFixed(type, IASTExpression.ValueCategory.LVALUE, IntegralValue.UNKNOWN)}, classType, OverloadableOperator.ARROW, CPPSemantics.LookupMode.NO_GLOBALS)) == null) break;
            if (functionBindings != null) {
                functionBindings.add(op);
            }
            type = ExpressionTypes.typeFromFunctionCall(op);
            type = SemanticUtil.mapToAST(type);
            ++j;
        }
        if ((prValue = ExpressionTypes.prvalueTypeWithResolvedTypedefs(type)) instanceof IPointerType) {
            return ExpressionTypes.glvalueType(((IPointerType)prValue).getType());
        }
        if (CPPTemplates.isDependentType(type)) {
            return returnDependent ? new TypeOfDependentExpression(new EvalUnary(4, (ICPPEvaluation)new EvalFixed(type, IASTExpression.ValueCategory.LVALUE, IntegralValue.UNKNOWN), null, CPPSemantics.getCurrentLookupPoint())) : null;
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            this.fType = this.computeType();
        }
        return this.fType;
    }

    private IType computeType() {
        if (this.fMember instanceof ICPPUnknownBinding) {
            return new TypeOfDependentExpression(this);
        }
        if (this.fMember instanceof IEnumerator) {
            return ((IEnumerator)this.fMember).getType();
        }
        if (this.fMember instanceof IVariable) {
            IType e2 = ((IVariable)this.fMember).getType();
            if ((e2 = SemanticUtil.getNestedType(e2, 1)) instanceof ICPPReferenceType) {
                e2 = ExpressionTypes.glvalueType(e2);
            } else if (this.fMember instanceof ICPPField && !((ICPPField)this.fMember).isStatic()) {
                e2 = this.addQualifiersForAccess((ICPPField)this.fMember, e2, this.fOwnerType);
            }
            return SemanticUtil.mapToAST(e2);
        }
        if (this.fMember instanceof IFunction) {
            return SemanticUtil.mapToAST(((IFunction)this.fMember).getType());
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    private IType addQualifiersForAccess(ICPPField field, IType fieldType, IType ownerType) {
        CVQualifier cvq1 = SemanticUtil.getCVQualifier(ownerType);
        CVQualifier cvq2 = SemanticUtil.getCVQualifier(fieldType);
        if (field.isMutable()) {
            if (cvq2.isConst()) {
                fieldType = SemanticUtil.getNestedType(fieldType, 21);
            }
            fieldType = SemanticUtil.addQualifiers(fieldType, false, cvq1.isVolatile() || cvq2.isVolatile(), cvq2.isRestrict());
        } else {
            fieldType = SemanticUtil.addQualifiers(fieldType, cvq1.isConst(), cvq1.isVolatile(), cvq2.isRestrict());
        }
        return fieldType;
    }

    @Override
    public IValue getValue() {
        if (this.fOwnerEval != null) {
            int fieldPos = CPPASTFieldReference.getFieldPosition(this.fMember, this.fOwnerType);
            IValue ownerValue = this.fOwnerEval.getValue();
            if (ownerValue instanceof CompositeValue) {
                CompositeValue compValue = (CompositeValue)ownerValue;
                ICPPEvaluation field = compValue.getSubValue(fieldPos);
                if (field != null) {
                    return field.getValue();
                }
            } else {
                return IntegralValue.UNKNOWN;
            }
        }
        if (this.fMember instanceof IEnumerator) {
            return ((IEnumerator)this.fMember).getValue();
        }
        if (this.fMember instanceof IVariable) {
            IValue initialValue = ((IVariable)this.fMember).getInitialValue();
            return initialValue == null ? IntegralValue.UNKNOWN : initialValue;
        }
        if (this.fMember instanceof IFunction) {
            return IntegralValue.UNKNOWN;
        }
        return DependentValue.create(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        if (this.fMember instanceof IVariable) {
            IType e2 = ((IVariable)this.fMember).getType();
            if ((e2 = SemanticUtil.getNestedType(e2, 1)) instanceof ICPPReferenceType) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            if (this.fMember instanceof ICPPField && !((ICPPField)this.fMember).isStatic()) {
                if (this.fIsPointerDeref) {
                    return IASTExpression.ValueCategory.LVALUE;
                }
                return this.fOwnerValueCategory == IASTExpression.ValueCategory.LVALUE ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.XVALUE;
            }
            return IASTExpression.ValueCategory.LVALUE;
        }
        if (this.fMember instanceof IFunction) {
            return IASTExpression.ValueCategory.LVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 12;
        if (this.fIsPointerDeref) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.fOwnerValueCategory == IASTExpression.ValueCategory.LVALUE) {
            firstBytes = (short)(firstBytes | 0x40);
        } else if (this.fOwnerValueCategory == IASTExpression.ValueCategory.XVALUE) {
            firstBytes = (short)(firstBytes | 0x80);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.fOwnerType);
        buffer.marshalBinding(this.fMember);
        buffer.marshalEvaluation(this.fOwnerEval, includeValue);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean isDeref;
        boolean bl = isDeref = (firstBytes & 0x20) != 0;
        IASTExpression.ValueCategory ownerValueCat = (firstBytes & 0x40) != 0 ? IASTExpression.ValueCategory.LVALUE : ((firstBytes & 0x80) != 0 ? IASTExpression.ValueCategory.XVALUE : IASTExpression.ValueCategory.PRVALUE);
        IType ownerType = buffer.unmarshalType();
        IBinding member = buffer.unmarshalBinding();
        ICPPEvaluation ownerEval = buffer.unmarshalEvaluation();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalMemberAccess(ownerType, ownerValueCat, member, ownerEval, isDeref, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation ownerEval;
        IType ownerType = CPPTemplates.instantiateType(this.fOwnerType, context);
        if (ownerType == this.fOwnerType && this.fOwnerEval == null) {
            return this;
        }
        IBinding member = this.fMember;
        IType ownerClass = SemanticUtil.getNestedType(ownerType, 16);
        if (ownerClass instanceof ICPPClassSpecialization) {
            member = ((ICPPClassSpecialization)ownerClass).specializeMember(this.fMember);
        }
        if ((ownerEval = this.fOwnerEval) != null) {
            ownerEval = ownerEval.instantiate(context, maxDepth);
            if (ownerType == this.fOwnerType && ownerEval == this.fOwnerEval) {
                return this;
            }
        }
        return new EvalMemberAccess(ownerType, this.fOwnerValueCategory, member, ownerEval, this.fIsPointerDeref, this.getTemplateDefinition());
    }

    private boolean isMemberAccessThroughThisPointer() {
        if (this.fOwnerEval == null) {
            return true;
        }
        if (this.fOwnerEval instanceof EvalFixed) {
            EvalFixed evalFixed = (EvalFixed)this.fOwnerEval;
            return evalFixed.getValue() == IntegralValue.THIS;
        }
        return false;
    }

    private ICPPEvaluation getOwnerEval(ActivationRecord record) {
        if (this.isMemberAccessThroughThisPointer()) {
            return record.getImplicitThis();
        }
        return this.fOwnerEval;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPField field;
        ICPPEvaluation ownerEval = this.getOwnerEval(record);
        if (this.fMember instanceof ICPPMethod) {
            EvalBinding evalBinding = new EvalBinding(this.fMember, this.fType, this.getTemplateDefinition());
            return evalBinding;
        }
        if (ownerEval == null || ownerEval == this) {
            return this;
        }
        int fieldPos = CPPASTFieldReference.getFieldPosition(this.fMember, this.fOwnerType);
        ICPPEvaluation evaluatedOwner = ownerEval.computeForFunctionCall(record, context);
        if (evaluatedOwner instanceof EvalPointer) {
            evaluatedOwner = ((EvalPointer)evaluatedOwner).dereference();
        }
        if (this.fMember instanceof ICPPField && (field = (ICPPField)this.fMember).getType() instanceof IArrayType) {
            EvalPointer evalPointer = new EvalPointer(record, new EvalCompositeAccess(new EvalCompositeAccess(evaluatedOwner, fieldPos), 0), this.getTemplateDefinition());
            return evalPointer;
        }
        EvalReference evalRef = new EvalReference(record, new EvalCompositeAccess(evaluatedOwner, fieldPos), this.getTemplateDefinition());
        return evalRef;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.determinePackSize(this.fOwnerType, tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }
}

