/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeFactoryFactory;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.CompositeValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecConstructorChain;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public final class EvalConstructor
extends CPPDependentEvaluation {
    private final IType fType;
    private final ICPPConstructor fConstructor;
    private final ICPPEvaluation[] fArguments;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;
    private static final IASTName TEMP_NAME = ASTNodeFactoryFactory.getDefaultCPPNodeFactory().newName();

    public EvalConstructor(IType type, ICPPConstructor constructor, ICPPEvaluation[] arguments, IBinding templateDefinition) {
        super(templateDefinition);
        this.fType = type;
        this.fConstructor = constructor;
        this.fArguments = arguments != null ? arguments : ICPPEvaluation.EMPTY_ARRAY;
    }

    public EvalConstructor(IType type, ICPPConstructor constructor, ICPPEvaluation[] arguments, IASTNode pointOfDefinition) {
        this(type, constructor, arguments, EvalConstructor.findEnclosingTemplate(pointOfDefinition));
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = CPPTemplates.isDependentType(this.fType) || EvalConstructor.containsDependentType(this.fArguments);
        }
        return this.fIsTypeDependent;
    }

    @Override
    public boolean isValueDependent() {
        if (CPPTemplates.isDependentType(this.fType)) {
            return true;
        }
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        return this.fConstructor.isConstexpr() && EvalConstructor.areAllConstantExpressions(this.fArguments);
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalConstructor)) {
            return false;
        }
        EvalConstructor o = (EvalConstructor)other;
        return this.fType.isSameType(o.fType) && this.fConstructor == o.fConstructor && EvalConstructor.areEquivalentEvaluations(this.fArguments, o.fArguments);
    }

    @Override
    public IType getType() {
        return this.fType;
    }

    public ICPPConstructor getConstructor() {
        return this.fConstructor;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public IValue getValue() {
        ICPPEvaluation computed = this.computeForFunctionCall(new ActivationRecord(), new ICPPEvaluation.ConstexprEvaluationContext());
        if (computed == this) {
            return IntegralValue.ERROR;
        }
        return computed.getValue();
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return null;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord callSiteRecord, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPField[] fields;
        IType unwrappedType = SemanticUtil.getNestedType(this.fType, 13);
        if (!(unwrappedType instanceof ICPPClassType)) {
            return this;
        }
        ICPPClassType classType = (ICPPClassType)unwrappedType;
        CompositeValue compositeValue = CompositeValue.create(classType);
        ICPPEvaluation[] argList = this.evaluateArguments(this.fArguments, callSiteRecord, context);
        EvalFixed constructedObject = new EvalFixed(this.fType, IASTExpression.ValueCategory.PRVALUE, compositeValue);
        CPPVariable binding = new CPPVariable(TEMP_NAME);
        ActivationRecord localRecord = EvalFunctionCall.createActivationRecord(this.fConstructor.getParameters(), argList, constructedObject);
        localRecord.update(binding, constructedObject);
        ICPPExecution exec = this.fConstructor.getConstructorChainExecution();
        if (exec instanceof ExecConstructorChain) {
            ExecConstructorChain memberInitList = (ExecConstructorChain)exec;
            Map<IBinding, ICPPEvaluation> ccInitializers = memberInitList.getConstructorChainInitializers();
            for (Map.Entry<IBinding, ICPPEvaluation> ccInitializer : ccInitializers.entrySet()) {
                ICPPField[] baseFields;
                if (!(ccInitializer.getKey() instanceof ICPPConstructor)) continue;
                ICPPClassType baseClassType = (ICPPClassType)ccInitializer.getKey().getOwner();
                ICPPEvaluation memberEval = ccInitializer.getValue();
                ICPPEvaluation memberValue = memberEval.computeForFunctionCall(localRecord, context.recordStep());
                ICPPEvaluation[] baseClassValues = memberValue.getValue().getAllSubValues();
                ICPPField[] iCPPFieldArray = baseFields = ClassTypeHelper.getFields(baseClassType);
                int n = baseFields.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPField baseField = iCPPFieldArray[n2];
                    int fieldPos = CPPASTFieldReference.getFieldPosition(baseField);
                    constructedObject.getValue().setSubValue(fieldPos, baseClassValues[fieldPos]);
                    ++n2;
                }
            }
        }
        ICPPField[] iCPPFieldArray = fields = classType.getDeclaredFields();
        int n = fields.length;
        int n3 = 0;
        while (n3 < n) {
            ICPPField field = iCPPFieldArray[n3];
            if (!field.isStatic()) {
                Map.Entry<IBinding, ICPPEvaluation> initializer = this.getInitializerFromMemberInitializerList(field, exec);
                ICPPEvaluation value = null;
                if (initializer != null) {
                    ExecDeclarator declaratorExec = this.getDeclaratorExecutionFromMemberInitializerList(initializer);
                    value = this.getFieldValue(declaratorExec, classType, localRecord, context);
                } else {
                    value = EvalUtil.getVariableValue(field, localRecord);
                }
                int fieldPos = CPPASTFieldReference.getFieldPosition(field);
                compositeValue.setSubValue(fieldPos, value);
            }
            ++n3;
        }
        new EvalFunctionCall(argList, (ICPPEvaluation)constructedObject, CPPSemantics.getCurrentLookupPoint()).computeForFunctionCall(localRecord, context.recordStep());
        return localRecord.getVariable(binding);
    }

    private Map.Entry<IBinding, ICPPEvaluation> getInitializerFromMemberInitializerList(ICPPField field, ICPPExecution exec) {
        if (!(exec instanceof ExecConstructorChain)) {
            return null;
        }
        ExecConstructorChain initList = (ExecConstructorChain)exec;
        for (Map.Entry<IBinding, ICPPEvaluation> init : initList.getConstructorChainInitializers().entrySet()) {
            IBinding member = init.getKey();
            if (!(member instanceof ICPPField) || !member.getName().equals(field.getName())) continue;
            return init;
        }
        return null;
    }

    private ExecDeclarator getDeclaratorExecutionFromMemberInitializerList(Map.Entry<IBinding, ICPPEvaluation> ccInitializer) {
        ICPPBinding member = (ICPPBinding)ccInitializer.getKey();
        ICPPEvaluation memberEval = ccInitializer.getValue();
        return new ExecDeclarator(member, memberEval);
    }

    private ICPPEvaluation getFieldValue(ExecDeclarator declaratorExec, ICPPClassType classType, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (declaratorExec == null) {
            return null;
        }
        if (declaratorExec.executeForFunctionCall(record, context) != ExecIncomplete.INSTANCE) {
            ICPPEvaluation value = record.getVariable(declaratorExec.getDeclaredBinding());
            return value;
        }
        return null;
    }

    public static ICPPEvaluation[] extractArguments(IASTInitializer initializer, ICPPConstructor constructor) {
        ICPPEvaluation[] args = EvalConstructor.extractArguments(initializer);
        if (args.length == 1 && constructor.getParameters().length > 1 && args[0] instanceof EvalInitList) {
            EvalInitList evalInitList = (EvalInitList)args[0];
            args = evalInitList.getClauses();
        }
        return args;
    }

    public static ICPPEvaluation[] extractArguments(IASTInitializer initializer) {
        if (initializer == null) {
            return ICPPEvaluation.EMPTY_ARRAY;
        }
        if (initializer instanceof ICPPASTConstructorInitializer) {
            ICPPASTConstructorInitializer ctorInitializer = (ICPPASTConstructorInitializer)initializer;
            return EvalConstructor.evaluateArguments(ctorInitializer.getArguments());
        }
        if (initializer instanceof ICPPASTInitializerList) {
            ICPPASTInitializerList initList = (ICPPASTInitializerList)initializer;
            return EvalConstructor.evaluateArguments(initList.getClauses());
        }
        if (initializer instanceof IASTEqualsInitializer) {
            IASTEqualsInitializer equalsInitalizer = (IASTEqualsInitializer)initializer;
            IASTInitializerClause initClause = equalsInitalizer.getInitializerClause();
            return EvalConstructor.evaluateArguments(initClause);
        }
        throw new IllegalArgumentException(String.valueOf(initializer.getClass().getSimpleName()) + " type of initializer is not supported");
    }

    private static ICPPEvaluation[] evaluateArguments(IASTInitializerClause ... clauses) {
        ICPPEvaluation[] args = new ICPPEvaluation[clauses.length];
        int i = 0;
        while (i < clauses.length) {
            ICPPASTInitializerClause clause = (ICPPASTInitializerClause)clauses[i];
            args[i] = clause.getEvaluation();
            ++i;
        }
        return args;
    }

    private ICPPEvaluation[] evaluateArguments(ICPPEvaluation[] arguments, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation[] argList = new ICPPEvaluation[arguments.length + 1];
        EvalBinding constructorBinding = new EvalBinding((IBinding)this.fConstructor, (IType)this.fConstructor.getType(), this.getTemplateDefinition());
        argList[0] = constructorBinding;
        int i = 0;
        while (i < arguments.length) {
            ICPPEvaluation evaluatedClause;
            argList[i + 1] = evaluatedClause = arguments[i].computeForFunctionCall(record, context.recordStep());
            ++i;
        }
        return argList;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = CPPTemplates.determinePackSize(this.fType, tpMap);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)17);
        buffer.marshalType(this.fType);
        buffer.marshalBinding(this.fConstructor);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType type = buffer.unmarshalType();
        ICPPConstructor constructor = (ICPPConstructor)buffer.unmarshalBinding();
        int len = buffer.getInt();
        ICPPEvaluation[] arguments = new ICPPEvaluation[len];
        int i = 0;
        while (i < arguments.length) {
            arguments[i] = buffer.unmarshalEvaluation();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalConstructor(type, constructor, arguments, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPConstructor newConstructor;
        ICPPEvaluation[] newArguments = new ICPPEvaluation[this.fArguments.length];
        int i = 0;
        while (i < this.fArguments.length) {
            newArguments[i] = this.fArguments[i].instantiate(context, maxDepth);
            ++i;
        }
        IType newType = null;
        try {
            EvalBinding evalBinding;
            CPPFunctionSet functionSet;
            EvalFunctionSet evalFunctionSet;
            ICPPEvaluation resolved;
            ICPPFunction[] candidates;
            newConstructor = (ICPPConstructor)CPPTemplates.instantiateBinding(this.fConstructor, context, maxDepth);
            if (newConstructor != null) {
                newType = newConstructor.getClassOwner();
            }
            if (newConstructor instanceof CPPDeferredFunction && (candidates = ((CPPDeferredFunction)((Object)newConstructor)).getCandidates()) != null && (resolved = (evalFunctionSet = new EvalFunctionSet(functionSet = new CPPFunctionSet(candidates, new ICPPTemplateArgument[0], null), false, false, newType, CPPSemantics.getCurrentLookupPoint())).resolveFunction(newArguments)) instanceof EvalBinding && (newConstructor = (ICPPConstructor)(evalBinding = (EvalBinding)resolved).getBinding()) != null) {
                newType = newConstructor.getClassOwner();
            }
        }
        catch (DOMException e) {
            newConstructor = this.fConstructor;
        }
        if (newType == null) {
            newType = CPPTemplates.instantiateType(this.fType, context);
        }
        return new EvalConstructor(newType, newConstructor, newArguments, this.getTemplateDefinition());
    }
}

