/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.helpers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.helpers.ModelQueryImpl;
import org.eclipse.bpel.validator.model.IConstants;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.bpel.validator.model.Validator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMNodeAdapter
implements INode {
    public static final String KEY = DOMNodeAdapter.class.getName();
    Validator mValidator = null;
    Node targetNode;
    Element targetElement;
    QName fNodeName;

    public DOMNodeAdapter(Node node) {
        this.targetNode = node;
        if (node.getNodeType() == 1) {
            this.targetElement = (Element)node;
            this.fNodeName = new QName(this.targetElement.getNamespaceURI(), this.targetElement.getLocalName());
        } else {
            this.fNodeName = new QName(this.targetNode.getNodeName());
        }
    }

    @Override
    public List<INode> children() {
        if (this.targetElement == null) {
            return Collections.emptyList();
        }
        Node node = this.targetElement.getFirstChild();
        LinkedList<INode> list = new LinkedList<INode>();
        while (node != null) {
            if (node.getNodeType() == 1) {
                list.addLast(this.adapt(node, INode.class));
            }
            node = node.getNextSibling();
        }
        return list;
    }

    @Override
    public String getAttribute(QName name) {
        String ns;
        if (this.targetElement == null) {
            return null;
        }
        String string = ns = name.getNamespaceURI().length() == 0 ? null : name.getNamespaceURI();
        if (this.targetElement.hasAttributeNS(ns, name.getLocalPart())) {
            return this.targetElement.getAttributeNS(ns, name.getLocalPart());
        }
        return null;
    }

    @Override
    public QName getAttributeAsQName(QName name) {
        String value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        return ModelQueryImpl.getModelQuery().createQName(this, value);
    }

    @Override
    public INode getNode(QName name) {
        List<INode> list = this.getNodeList(name);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<INode> getNodeList(QName name) {
        if (this.targetElement == null) {
            return Collections.emptyList();
        }
        LinkedList<INode> list = new LinkedList<INode>();
        Node node = this.targetElement.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                if (name.getNamespaceURI().equals(e.getNamespaceURI()) && name.getLocalPart().equals(e.getLocalName())) {
                    list.addLast(this.adapt(node, INode.class));
                }
            }
            node = node.getNextSibling();
        }
        return list;
    }

    @Override
    public boolean isResolved() {
        return this.targetElement != null;
    }

    @Override
    public QName nodeName() {
        return this.fNodeName;
    }

    @Override
    public Validator nodeValidator() {
        if (this.mValidator == null) {
            this.mValidator = this.createValidator();
            if (this.mValidator != null) {
                this.mValidator.setNode(this);
            }
        }
        return this.mValidator;
    }

    @Override
    public Object nodeValue() {
        return this.targetNode;
    }

    @Override
    public INode parentNode() {
        if (this.targetNode == null) {
            return null;
        }
        Node parent = this.targetNode.getParentNode();
        if (parent == this.targetNode.getOwnerDocument()) {
            return null;
        }
        return this.adapt(parent, INode.class);
    }

    @Override
    public INode rootNode() {
        if (this.targetNode == null) {
            return null;
        }
        Element node = this.targetNode.getOwnerDocument().getDocumentElement();
        return this.adapt(node, INode.class);
    }

    protected <T> T adapt(Object target, Class<T> type) {
        IModelQuery mq = ModelQueryImpl.getModelQuery();
        return mq.adapt(target, type, 0);
    }

    Validator createValidator() {
        QName qname = new QName(this.targetElement.getNamespaceURI(), this.targetElement.getLocalName());
        return RuleFactory.INSTANCE.createValidator(qname);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        String pfx = this.targetElement.getPrefix();
        if (pfx != null && pfx.length() > 0) {
            sb.append(pfx);
            sb.append(":");
        }
        sb.append(this.targetElement.getLocalName());
        String vName = this.getAttribute(IConstants.AT_NAME);
        if (vName != null) {
            sb.append(" \"").append(vName).append("\"");
        }
        sb.append(">");
        return sb.toString();
    }
}

