/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.Collections;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.extension.model.ExtensionmodelFactory;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class BPELReader {
    protected Resource processResource;
    protected Resource extensionsResource;
    protected Process process;
    protected ExtensionMap extensionMap;

    public void read(Resource processResource, IFile modelFile, ResourceSet resourceSet) {
        EcorePackage instance = EcorePackage.eINSTANCE;
        instance.eAdapters();
        this.processResource = processResource;
        IPath extensionsPath = modelFile.getFullPath().removeFileExtension().addFileExtension("bpelex");
        URI extensionsUri = URI.createPlatformResourceURI((String)extensionsPath.toString());
        IFile extensionsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(extensionsPath);
        try {
            processResource.load(Collections.EMPTY_MAP);
            EList contents = processResource.getContents();
            if (!contents.isEmpty()) {
                this.process = (Process)contents.get(0);
            }
        }
        catch (Exception e) {
            BPELUIPlugin.log(e);
        }
        try {
            this.extensionsResource = resourceSet.getResource(extensionsUri, extensionsFile.exists());
            if (this.extensionsResource != null) {
                this.extensionMap = ExtensionmodelFactory.eINSTANCE.findExtensionMap("http://org.eclipse.bpel.ui/", this.extensionsResource.getContents());
            }
            if (this.extensionMap != null) {
                this.extensionMap.initializeAdapter();
            }
        }
        catch (Exception e) {
            BPELUIPlugin.log(e);
        }
        if (this.process == null) {
            this.process = BPELFactory.eINSTANCE.createProcess();
            processResource.getContents().add((Object)this.process);
        }
        if (this.extensionMap == null) {
            this.extensionMap = ExtensionmodelFactory.eINSTANCE.createExtensionMap("http://org.eclipse.bpel.ui/");
            if (this.extensionsResource == null) {
                this.extensionsResource = resourceSet.createResource(extensionsUri);
            }
            this.extensionsResource.getContents().clear();
            this.extensionsResource.getContents().add((Object)this.extensionMap);
        }
        if (this.process.getVariables() == null) {
            this.process.setVariables(BPELFactory.eINSTANCE.createVariables());
        }
        if (this.process.getPartnerLinks() == null) {
            this.process.setPartnerLinks(BPELFactory.eINSTANCE.createPartnerLinks());
        }
        if (this.process.getCorrelationSets() == null) {
            this.process.setCorrelationSets(BPELFactory.eINSTANCE.createCorrelationSets());
        }
        if (this.process.getMessageExchanges() == null) {
            this.process.setMessageExchanges(BPELFactory.eINSTANCE.createMessageExchanges());
        }
        TreeIterator iter = this.process.eAllContents();
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            if (!(object instanceof Scope)) continue;
            Scope scope = (Scope)object;
            if (scope.getVariables() == null) {
                scope.setVariables(BPELFactory.eINSTANCE.createVariables());
            }
            if (scope.getPartnerLinks() == null) {
                scope.setPartnerLinks(BPELFactory.eINSTANCE.createPartnerLinks());
            }
            if (scope.getCorrelationSets() == null) {
                scope.setCorrelationSets(BPELFactory.eINSTANCE.createCorrelationSets());
            }
            if (scope.getMessageExchanges() != null) continue;
            scope.setMessageExchanges(BPELFactory.eINSTANCE.createMessageExchanges());
        }
        TreeIterator it = this.process.eAllContents();
        while (it.hasNext()) {
            ModelHelper.createExtensionIfNecessary(this.extensionMap, (EObject)it.next());
        }
        if (this.extensionMap.get((Object)this.process) == null) {
            ModelHelper.createExtensionIfNecessary(this.extensionMap, (EObject)this.process);
        }
    }

    public ExtensionMap getExtensionMap() {
        return this.extensionMap;
    }

    public Resource getExtensionsResource() {
        return this.extensionsResource;
    }

    public Process getProcess() {
        return this.process;
    }
}

