/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IHoverHelper;
import org.eclipse.bpel.ui.IHoverHelperSupport;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.editparts.policies.BPELComponentEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELDirectEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.util.BPELCellEditorLocator;
import org.eclipse.bpel.ui.util.BPELDirectEditManager;
import org.eclipse.bpel.ui.util.BPELDragEditPartsTracker;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.marker.BPELEditPartMarkerDecorator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.TextCellEditor;

public abstract class BPELEditPart
extends AbstractGraphicalEditPart
implements IHoverHelperSupport {
    public static final int SPACING = 14;
    protected static String EMPTY_STRING = "";
    protected AccessibleEditPart acc;
    protected MultiObjectAdapter adapter = new MultiObjectAdapter(){

        @Override
        public void notify(Notification n) {
            int eventGroup = n.getEventType() / 100;
            if (eventGroup == 21) {
                BPELEditPart.this.refreshVisuals();
                return;
            }
            if (BPELEditPart.this.isActive()) {
                BPELEditPart.this.handleModelChanged();
            }
            BPELEditPart.this.refreshAdapters();
        }
    };
    protected BPELEditPartMarkerDecorator.MarkerMotionListener markerMotionListener;
    private DirectEditManager manager;
    protected int mouseLocation = 0;

    protected List getModelChildren() {
        IContainer container = BPELUtil.adapt(this.getModel(), IContainer.class);
        if (container != null) {
            return container.getChildren(this.getModel());
        }
        return super.getModelChildren();
    }

    protected void addAllAdapters() {
        EObject modelObject = (EObject)this.getModel();
        this.adapter.addToObject((Notifier)modelObject);
        EObject extension = ModelHelper.getExtension(modelObject);
        if (extension != null) {
            this.adapter.addToObject((Notifier)extension);
        }
        try {
            Activity activity = ModelHelper.getActivity(modelObject);
            if (activity instanceof Sequence) {
                this.adapter.addToObject((Notifier)activity);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void removeAllAdapters() {
        this.adapter.removeFromAll();
    }

    protected void refreshAdapters() {
        this.removeAllAdapters();
        this.addAllAdapters();
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.addAllAdapters();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.removeAllAdapters();
        super.deactivate();
        this.clearConnections();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BPELComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new BPELDirectEditPolicy());
    }

    protected void handleModelChanged() {
        this.refreshChildren();
        this.refreshVisuals();
        this.refresh();
    }

    public ConnectionAnchor getConnectionAnchor(int location) {
        return new CenteredConnectionAnchor(this.getFigure(), location, 0);
    }

    public boolean canExecuteRequest(Request request) {
        AbstractEditPart.EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            Command cm = i.next().getCommand(request);
            if (cm == null || !cm.canExecute()) continue;
            return true;
        }
        return false;
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    public boolean canPerformDirectEdit() {
        return this.getLabelFigure() != null;
    }

    public void performDirectEdit() {
        if (this.getLabelFigure() != null) {
            Command cmd = BPELDirectEditPolicy.getFinalizeCommand(this.getModel(), "blahblah");
            if (cmd == null || !cmd.canExecute()) {
                return;
            }
            if (this.manager == null) {
                this.manager = new BPELDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new BPELCellEditorLocator(this.getLabelFigure()), this.getLabelValidator());
            }
            this.manager.show();
        }
    }

    public Label getLabelFigure() {
        return null;
    }

    public String getLabelContent() {
        return null;
    }

    public void setLabelContent(String str) {
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        this.refreshHoverHelp();
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshConnections();
    }

    protected void refreshConnections() {
        EditPolicy policy = this.getEditPolicy("LayoutEditPolicy");
        if (policy instanceof BPELOrderedLayoutEditPolicy) {
            ((BPELOrderedLayoutEditPolicy)policy).refreshConnections();
        }
    }

    protected void clearConnections() {
        EditPolicy policy = this.getEditPolicy("LayoutEditPolicy");
        if (policy instanceof BPELOrderedLayoutEditPolicy) {
            ((BPELOrderedLayoutEditPolicy)policy).clearConnections();
        }
    }

    public Object getAdapter(Class key) {
        if (key.isInstance(this.getModel())) {
            return this.getModel();
        }
        if (key == AccessibleAnchorProvider.class) {
            return new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                private List<Point> getDefaultLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    Rectangle r = BPELEditPart.this.getFigure().getBounds();
                    Point p = r.getTopRight().translate(-r.width / 2, r.height / 3);
                    BPELEditPart.this.getFigure().translateToAbsolute((Translatable)p);
                    list.add(p);
                    return list;
                }

                public List<Point> getSourceAnchorLocations() {
                    return this.getDefaultLocations();
                }

                public List<Point> getTargetAnchorLocations() {
                    return this.getDefaultLocations();
                }
            };
        }
        return super.getAdapter(key);
    }

    public void regenerateVisuals() {
    }

    public void refreshSourceConnections() {
        super.refreshSourceConnections();
    }

    public void refreshTargetConnections() {
        super.refreshTargetConnections();
    }

    @Override
    public void refreshHoverHelp() {
        try {
            IHoverHelper helper = BPELUIRegistry.getInstance().getHoverHelper();
            if (helper != null) {
                IFigure tooltip = helper.getHoverFigure((EObject)this.getModel());
                this.getFigure().setToolTip(tooltip);
            }
        }
        catch (CoreException e) {
            this.getFigure().setToolTip(null);
            BPELUIPlugin.log(e);
        }
    }

    protected IFigure createFigure() {
        return null;
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    protected AccessibleEditPart createAccessible() {
        return BPELUtil.getAccessibleEditPart((GraphicalEditPart)this);
    }

    protected BPELEditPartMarkerDecorator.MarkerMotionListener getMarkerMotionListener() {
        this.markerMotionListener = new BPELEditPartMarkerDecorator.MarkerMotionListener(){

            @Override
            public void markerEntered(IMarker marker) {
                BPELEditPart.this.mouseLocation = 3;
                BPELEditPart.this.refreshHoverHelp();
            }
        };
        return this.markerMotionListener;
    }

    public DragTracker getDragTracker(Request request) {
        return new BPELDragEditPartsTracker((EditPart)this);
    }

    protected IInputValidator getLabelValidator() {
        return null;
    }
}

